'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = polyfillInstancedArrays;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function polyfillInstancedArrays(gl) {
  // Only add if WebGL2RenderingContext is not available
  if (!(gl instanceof WebGL2RenderingContext)) {
    var ext = gl.getExtension('ANGLE_instanced_arrays');
    (0, _assert2.default)(ext, 'WebGL extension not available: ANGLE_instanced_arrays');

    var _WebGLRenderingContex = WebGLRenderingContext,
        prototype = _WebGLRenderingContex.prototype;

    prototype.vertexAttribDivisor = ext.vertexAttribDivisorANGLE.bind(ext);
    prototype.drawArraysInstanced = ext.drawArraysInstancedANGLE.bind(ext);
    prototype.drawElementsInstanced = ext.drawElementsInstancedANGLE.bind(ext);
    prototype.VERTEX_ATTRIB_ARRAY_DIVISOR = ext.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE;
  }
} // WebGL2 Polyfills for instanced rendering
// using ANGLE_instanced_arrays extension

/* eslint-disable max-params */
/* global WebGLRenderingContext, WebGL2RenderingContext */
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy93ZWJnbC9wb2x5ZmlsbC9pbnN0YW5jZWQtYXJyYXlzLmpzIl0sIm5hbWVzIjpbInBvbHlmaWxsSW5zdGFuY2VkQXJyYXlzIiwiZ2wiLCJXZWJHTDJSZW5kZXJpbmdDb250ZXh0IiwiZXh0IiwiZ2V0RXh0ZW5zaW9uIiwiV2ViR0xSZW5kZXJpbmdDb250ZXh0IiwicHJvdG90eXBlIiwidmVydGV4QXR0cmliRGl2aXNvciIsInZlcnRleEF0dHJpYkRpdmlzb3JBTkdMRSIsImJpbmQiLCJkcmF3QXJyYXlzSW5zdGFuY2VkIiwiZHJhd0FycmF5c0luc3RhbmNlZEFOR0xFIiwiZHJhd0VsZW1lbnRzSW5zdGFuY2VkIiwiZHJhd0VsZW1lbnRzSW5zdGFuY2VkQU5HTEUiLCJWRVJURVhfQVRUUklCX0FSUkFZX0RJVklTT1IiLCJWRVJURVhfQVRUUklCX0FSUkFZX0RJVklTT1JfQU5HTEUiXSwibWFwcGluZ3MiOiI7Ozs7O2tCQU93QkEsdUI7O0FBRnhCOzs7Ozs7QUFFZSxTQUFTQSx1QkFBVCxDQUFpQ0MsRUFBakMsRUFBcUM7QUFDbEQ7QUFDQSxNQUFJLEVBQUVBLGNBQWNDLHNCQUFoQixDQUFKLEVBQTZDO0FBQzNDLFFBQU1DLE1BQU1GLEdBQUdHLFlBQUgsQ0FBZ0Isd0JBQWhCLENBQVo7QUFDQSwwQkFBT0QsR0FBUCxFQUFZLHVEQUFaOztBQUYyQyxnQ0FJdkJFLHFCQUp1QjtBQUFBLFFBSXBDQyxTQUpvQyx5QkFJcENBLFNBSm9DOztBQUszQ0EsY0FBVUMsbUJBQVYsR0FBZ0NKLElBQUlLLHdCQUFKLENBQTZCQyxJQUE3QixDQUFrQ04sR0FBbEMsQ0FBaEM7QUFDQUcsY0FBVUksbUJBQVYsR0FBZ0NQLElBQUlRLHdCQUFKLENBQTZCRixJQUE3QixDQUFrQ04sR0FBbEMsQ0FBaEM7QUFDQUcsY0FBVU0scUJBQVYsR0FBa0NULElBQUlVLDBCQUFKLENBQStCSixJQUEvQixDQUFvQ04sR0FBcEMsQ0FBbEM7QUFDQUcsY0FBVVEsMkJBQVYsR0FDRVgsSUFBSVksaUNBRE47QUFFRDtBQUNGLEMsQ0FwQkQ7QUFDQTs7QUFFQTtBQUNBIiwiZmlsZSI6Imluc3RhbmNlZC1hcnJheXMuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBXZWJHTDIgUG9seWZpbGxzIGZvciBpbnN0YW5jZWQgcmVuZGVyaW5nXG4vLyB1c2luZyBBTkdMRV9pbnN0YW5jZWRfYXJyYXlzIGV4dGVuc2lvblxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtcGFyYW1zICovXG4vKiBnbG9iYWwgV2ViR0xSZW5kZXJpbmdDb250ZXh0LCBXZWJHTDJSZW5kZXJpbmdDb250ZXh0ICovXG5pbXBvcnQgYXNzZXJ0IGZyb20gJ2Fzc2VydCc7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHBvbHlmaWxsSW5zdGFuY2VkQXJyYXlzKGdsKSB7XG4gIC8vIE9ubHkgYWRkIGlmIFdlYkdMMlJlbmRlcmluZ0NvbnRleHQgaXMgbm90IGF2YWlsYWJsZVxuICBpZiAoIShnbCBpbnN0YW5jZW9mIFdlYkdMMlJlbmRlcmluZ0NvbnRleHQpKSB7XG4gICAgY29uc3QgZXh0ID0gZ2wuZ2V0RXh0ZW5zaW9uKCdBTkdMRV9pbnN0YW5jZWRfYXJyYXlzJyk7XG4gICAgYXNzZXJ0KGV4dCwgJ1dlYkdMIGV4dGVuc2lvbiBub3QgYXZhaWxhYmxlOiBBTkdMRV9pbnN0YW5jZWRfYXJyYXlzJyk7XG5cbiAgICBjb25zdCB7cHJvdG90eXBlfSA9IFdlYkdMUmVuZGVyaW5nQ29udGV4dDtcbiAgICBwcm90b3R5cGUudmVydGV4QXR0cmliRGl2aXNvciA9IGV4dC52ZXJ0ZXhBdHRyaWJEaXZpc29yQU5HTEUuYmluZChleHQpO1xuICAgIHByb3RvdHlwZS5kcmF3QXJyYXlzSW5zdGFuY2VkID0gZXh0LmRyYXdBcnJheXNJbnN0YW5jZWRBTkdMRS5iaW5kKGV4dCk7XG4gICAgcHJvdG90eXBlLmRyYXdFbGVtZW50c0luc3RhbmNlZCA9IGV4dC5kcmF3RWxlbWVudHNJbnN0YW5jZWRBTkdMRS5iaW5kKGV4dCk7XG4gICAgcHJvdG90eXBlLlZFUlRFWF9BVFRSSUJfQVJSQVlfRElWSVNPUiA9XG4gICAgICBleHQuVkVSVEVYX0FUVFJJQl9BUlJBWV9ESVZJU09SX0FOR0xFO1xuICB9XG59XG4iXX0=