'use strict';

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createVertexArray(gl) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  return ext.createVertexArrayOES();
} // WebGL2 Polyfills for iVertexArray Objects
// using OES_vertex_array_object extension

/* global WebGLRenderingContext, WebGL2RenderingContext */


function deleteVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  ext.deleteVertexArrayOES(vertexArray);
}

function isVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  return ext.isVertexArrayOES(vertexArray);
}

function bindVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  return ext.bindVertexArrayOES(vertexArray);
}

// Only add if WebGL2RenderingContext is not available
if (!WebGL2RenderingContext) {

  var prototype = WebGLRenderingContext.prototype;

  prototype.createVertexArray = prototype.createVertexArray || createVertexArray;

  prototype.deleteVertexArray = prototype.deleteVertexArray || deleteVertexArray;

  prototype.isVertexArray = prototype.isVertexArray || isVertexArray;

  prototype.bindVertexArray = prototype.bindVertexArray || bindVertexArray;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy93ZWJnbC9wb2x5ZmlsbC92ZXJ0ZXgtYXJyYXktb2JqZWN0LmpzIl0sIm5hbWVzIjpbImNyZWF0ZVZlcnRleEFycmF5IiwiZ2wiLCJleHQiLCJnZXRFeHRlbnNpb24iLCJjcmVhdGVWZXJ0ZXhBcnJheU9FUyIsImRlbGV0ZVZlcnRleEFycmF5IiwidmVydGV4QXJyYXkiLCJkZWxldGVWZXJ0ZXhBcnJheU9FUyIsImlzVmVydGV4QXJyYXkiLCJpc1ZlcnRleEFycmF5T0VTIiwiYmluZFZlcnRleEFycmF5IiwiYmluZFZlcnRleEFycmF5T0VTIiwiV2ViR0wyUmVuZGVyaW5nQ29udGV4dCIsInByb3RvdHlwZSIsIldlYkdMUmVuZGVyaW5nQ29udGV4dCJdLCJtYXBwaW5ncyI6Ijs7QUFJQTs7Ozs7O0FBRUEsU0FBU0EsaUJBQVQsQ0FBMkJDLEVBQTNCLEVBQStCO0FBQzdCLE1BQU1DLE1BQU1ELEdBQUdFLFlBQUgsQ0FBZ0IseUJBQWhCLENBQVo7QUFDQSx3QkFBT0YsRUFBUCxFQUFXLHlCQUFYO0FBQ0EsU0FBT0MsSUFBSUUsb0JBQUosRUFBUDtBQUNELEMsQ0FWRDtBQUNBOztBQUVBOzs7QUFTQSxTQUFTQyxpQkFBVCxDQUEyQkosRUFBM0IsRUFBK0JLLFdBQS9CLEVBQTRDO0FBQzFDLE1BQU1KLE1BQU1ELEdBQUdFLFlBQUgsQ0FBZ0IseUJBQWhCLENBQVo7QUFDQSx3QkFBT0YsRUFBUCxFQUFXLHlCQUFYO0FBQ0FDLE1BQUlLLG9CQUFKLENBQXlCRCxXQUF6QjtBQUNEOztBQUVELFNBQVNFLGFBQVQsQ0FBdUJQLEVBQXZCLEVBQTJCSyxXQUEzQixFQUF3QztBQUN0QyxNQUFNSixNQUFNRCxHQUFHRSxZQUFILENBQWdCLHlCQUFoQixDQUFaO0FBQ0Esd0JBQU9GLEVBQVAsRUFBVyx5QkFBWDtBQUNBLFNBQU9DLElBQUlPLGdCQUFKLENBQXFCSCxXQUFyQixDQUFQO0FBQ0Q7O0FBRUQsU0FBU0ksZUFBVCxDQUF5QlQsRUFBekIsRUFBNkJLLFdBQTdCLEVBQTBDO0FBQ3hDLE1BQU1KLE1BQU1ELEdBQUdFLFlBQUgsQ0FBZ0IseUJBQWhCLENBQVo7QUFDQSx3QkFBT0YsRUFBUCxFQUFXLHlCQUFYO0FBQ0EsU0FBT0MsSUFBSVMsa0JBQUosQ0FBdUJMLFdBQXZCLENBQVA7QUFDRDs7QUFFRDtBQUNBLElBQUksQ0FBQ00sc0JBQUwsRUFBNkI7O0FBRTNCLE1BQU1DLFlBQVlDLHNCQUFzQkQsU0FBeEM7O0FBRUFBLFlBQVViLGlCQUFWLEdBQThCYSxVQUFVYixpQkFBVixJQUM1QkEsaUJBREY7O0FBR0FhLFlBQVVSLGlCQUFWLEdBQThCUSxVQUFVUixpQkFBVixJQUM1QkEsaUJBREY7O0FBR0FRLFlBQVVMLGFBQVYsR0FBMEJLLFVBQVVMLGFBQVYsSUFBMkJBLGFBQXJEOztBQUVBSyxZQUFVSCxlQUFWLEdBQTRCRyxVQUFVSCxlQUFWLElBQTZCQSxlQUF6RDtBQUVEIiwiZmlsZSI6InZlcnRleC1hcnJheS1vYmplY3QuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBXZWJHTDIgUG9seWZpbGxzIGZvciBpVmVydGV4QXJyYXkgT2JqZWN0c1xuLy8gdXNpbmcgT0VTX3ZlcnRleF9hcnJheV9vYmplY3QgZXh0ZW5zaW9uXG5cbi8qIGdsb2JhbCBXZWJHTFJlbmRlcmluZ0NvbnRleHQsIFdlYkdMMlJlbmRlcmluZ0NvbnRleHQgKi9cbmltcG9ydCBhc3NlcnQgZnJvbSAnYXNzZXJ0JztcblxuZnVuY3Rpb24gY3JlYXRlVmVydGV4QXJyYXkoZ2wpIHtcbiAgY29uc3QgZXh0ID0gZ2wuZ2V0RXh0ZW5zaW9uKCdPRVNfdmVydGV4X2FycmF5X29iamVjdCcpO1xuICBhc3NlcnQoZ2wsICdPRVNfdmVydGV4X2FycmF5X29iamVjdCcpO1xuICByZXR1cm4gZXh0LmNyZWF0ZVZlcnRleEFycmF5T0VTKCk7XG59XG5cbmZ1bmN0aW9uIGRlbGV0ZVZlcnRleEFycmF5KGdsLCB2ZXJ0ZXhBcnJheSkge1xuICBjb25zdCBleHQgPSBnbC5nZXRFeHRlbnNpb24oJ09FU192ZXJ0ZXhfYXJyYXlfb2JqZWN0Jyk7XG4gIGFzc2VydChnbCwgJ09FU192ZXJ0ZXhfYXJyYXlfb2JqZWN0Jyk7XG4gIGV4dC5kZWxldGVWZXJ0ZXhBcnJheU9FUyh2ZXJ0ZXhBcnJheSk7XG59XG5cbmZ1bmN0aW9uIGlzVmVydGV4QXJyYXkoZ2wsIHZlcnRleEFycmF5KSB7XG4gIGNvbnN0IGV4dCA9IGdsLmdldEV4dGVuc2lvbignT0VTX3ZlcnRleF9hcnJheV9vYmplY3QnKTtcbiAgYXNzZXJ0KGdsLCAnT0VTX3ZlcnRleF9hcnJheV9vYmplY3QnKTtcbiAgcmV0dXJuIGV4dC5pc1ZlcnRleEFycmF5T0VTKHZlcnRleEFycmF5KTtcbn1cblxuZnVuY3Rpb24gYmluZFZlcnRleEFycmF5KGdsLCB2ZXJ0ZXhBcnJheSkge1xuICBjb25zdCBleHQgPSBnbC5nZXRFeHRlbnNpb24oJ09FU192ZXJ0ZXhfYXJyYXlfb2JqZWN0Jyk7XG4gIGFzc2VydChnbCwgJ09FU192ZXJ0ZXhfYXJyYXlfb2JqZWN0Jyk7XG4gIHJldHVybiBleHQuYmluZFZlcnRleEFycmF5T0VTKHZlcnRleEFycmF5KTtcbn1cblxuLy8gT25seSBhZGQgaWYgV2ViR0wyUmVuZGVyaW5nQ29udGV4dCBpcyBub3QgYXZhaWxhYmxlXG5pZiAoIVdlYkdMMlJlbmRlcmluZ0NvbnRleHQpIHtcblxuICBjb25zdCBwcm90b3R5cGUgPSBXZWJHTFJlbmRlcmluZ0NvbnRleHQucHJvdG90eXBlO1xuXG4gIHByb3RvdHlwZS5jcmVhdGVWZXJ0ZXhBcnJheSA9IHByb3RvdHlwZS5jcmVhdGVWZXJ0ZXhBcnJheSB8fFxuICAgIGNyZWF0ZVZlcnRleEFycmF5O1xuXG4gIHByb3RvdHlwZS5kZWxldGVWZXJ0ZXhBcnJheSA9IHByb3RvdHlwZS5kZWxldGVWZXJ0ZXhBcnJheSB8fFxuICAgIGRlbGV0ZVZlcnRleEFycmF5O1xuXG4gIHByb3RvdHlwZS5pc1ZlcnRleEFycmF5ID0gcHJvdG90eXBlLmlzVmVydGV4QXJyYXkgfHwgaXNWZXJ0ZXhBcnJheTtcblxuICBwcm90b3R5cGUuYmluZFZlcnRleEFycmF5ID0gcHJvdG90eXBlLmJpbmRWZXJ0ZXhBcnJheSB8fCBiaW5kVmVydGV4QXJyYXk7XG5cbn1cblxuIl19