'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('./webgl');

var _webgl2 = _interopRequireDefault(_webgl);

var _webglChecks = require('./webgl-checks');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Renderbuffer = function () {
  _createClass(Renderbuffer, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Renderbuffer ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Renderbuffer(gl, { handle: object.handle || object });
    }
  }]);

  function Renderbuffer(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Renderbuffer);

    (0, _webglChecks.assertWebGLContext)(gl);

    this.gl = gl;
    this.handle = gl.createRenderbuffer();
    if (!this.handle) {
      throw new Error('Failed to create WebGL Renderbuffer');
    }
  }

  _createClass(Renderbuffer, [{
    key: 'delete',
    value: function _delete() {
      this.gl.deleteRenderbuffer(this.handle);
      return this;
    }
  }, {
    key: 'bind',
    value: function bind() {
      this.gl.bindRenderbuffer(_webgl2.default.RENDERBUFFER, this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      this.gl.bindRenderbuffer(_webgl2.default.RENDERBUFFER, null);
      return this;
    }

    /**
     * Creates and initializes a renderbuffer object's data store
     *
     * @param {GLenum} opt.internalFormat -
     * @param {GLint} opt.width -
     * @param {GLint} opt.height
     * @param {Boolean} opt.autobind=true - method call will bind/unbind object
     * @returns {Renderbuffer} returns itself to enable chaining
     */

  }, {
    key: 'storage',
    value: function storage(_ref) {
      var internalFormat = _ref.internalFormat,
          width = _ref.width,
          height = _ref.height;
      var gl = this.gl;

      (0, _assert2.default)(internalFormat, 'Needs internalFormat');
      this.bind();
      gl.renderbufferStorage(_webgl2.default.RENDERBUFFER, (0, _webgl.glGet)(internalFormat), width, height);
      this.unbind();
      return this;
    }

    // @param {Boolean} opt.autobind=true - method call will bind/unbind object
    // @returns {GLenum|GLint} - depends on pname

  }, {
    key: 'getParameter',
    value: function getParameter(pname) {
      var gl = this.gl;

      this.bind();
      var value = gl.getRenderbufferParameter(_webgl2.default.RENDERBUFFER, (0, _webgl.glGet)(pname));
      this.unbind();
      return value;
    }

    // @returns {GLint} - width of the image of the currently bound renderbuffer.

  }, {
    key: 'storageMultisample',


    // WEBGL2 METHODS

    // (OpenGL ES 3.0.4 §4.4.2)
    value: function storageMultisample() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          samples = _ref2.samples,
          internalformat = _ref2.internalformat,
          width = _ref2.width,
          height = _ref2.height;

      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      gl.renderbufferStorageMultisample(_webgl2.default.RENDERBUFFER, samples, internalformat, width, height);
      return this;
    }

    // (OpenGL ES 3.0.4 §6.1.15)

  }, {
    key: 'getInternalformatParameter',
    value: function getInternalformatParameter(_ref3) {
      var internalformat = _ref3.internalformat,
          _ref3$pname = _ref3.pname,
          pname = _ref3$pname === undefined ? 'SAMPLES' : _ref3$pname;
      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      return gl.getInternalformatParameter(_webgl2.default.RENDERBUFFER, internalformat, pname);
    }
  }, {
    key: 'width',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_WIDTH);
    }

    // @returns {GLint} - height of the image of the currently bound renderbuffer.

  }, {
    key: 'height',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_HEIGHT);
    }

    // @returns {GLenum} internal format of the currently bound renderbuffer.
    // The default is gl.RGBA4. Possible return values:
    // gl.RGBA4: 4 red bits, 4 green bits, 4 blue bits 4 alpha bits.
    // gl.RGB565: 5 red bits, 6 green bits, 5 blue bits.
    // gl.RGB5_A1: 5 red bits, 5 green bits, 5 blue bits, 1 alpha bit.
    // gl.DEPTH_COMPONENT16: 16 depth bits.
    // gl.STENCIL_INDEX8: 8 stencil bits.

  }, {
    key: 'internalFormat',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_INTERNAL_FORMAT);
    }

    //  @returns {GLint} - resolution size (in bits) for the green color.

  }, {
    key: 'greenSize',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_GREEN_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the blue color.

  }, {
    key: 'blueSize',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_BLUE_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the red color.

  }, {
    key: 'redSize',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_RED_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the alpha component.

  }, {
    key: 'alphaSize',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_ALPHA_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the depth component.

  }, {
    key: 'depthSize',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_DEPTH_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the stencil component.

  }, {
    key: 'stencilSize',
    get: function get() {
      return this.getParameter(_webgl2.default.RENDERBUFFER_STENCIL_SIZE);
    }

    // When using a WebGL 2 context, the following value is available

  }, {
    key: 'samples',
    get: function get() {
      return this.getParameter(this.gl.RENDERBUFFER_SAMPLES);
    }
  }]);

  return Renderbuffer;
}();

exports.default = Renderbuffer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWJnbC9yZW5kZXJidWZmZXIuanMiXSwibmFtZXMiOlsiUmVuZGVyYnVmZmVyIiwiZ2wiLCJvYmplY3QiLCJoYW5kbGUiLCJvcHRzIiwiY3JlYXRlUmVuZGVyYnVmZmVyIiwiRXJyb3IiLCJkZWxldGVSZW5kZXJidWZmZXIiLCJiaW5kUmVuZGVyYnVmZmVyIiwiUkVOREVSQlVGRkVSIiwiaW50ZXJuYWxGb3JtYXQiLCJ3aWR0aCIsImhlaWdodCIsImJpbmQiLCJyZW5kZXJidWZmZXJTdG9yYWdlIiwidW5iaW5kIiwicG5hbWUiLCJ2YWx1ZSIsImdldFJlbmRlcmJ1ZmZlclBhcmFtZXRlciIsInNhbXBsZXMiLCJpbnRlcm5hbGZvcm1hdCIsInJlbmRlcmJ1ZmZlclN0b3JhZ2VNdWx0aXNhbXBsZSIsImdldEludGVybmFsZm9ybWF0UGFyYW1ldGVyIiwiZ2V0UGFyYW1ldGVyIiwiUkVOREVSQlVGRkVSX1dJRFRIIiwiUkVOREVSQlVGRkVSX0hFSUdIVCIsIlJFTkRFUkJVRkZFUl9JTlRFUk5BTF9GT1JNQVQiLCJSRU5ERVJCVUZGRVJfR1JFRU5fU0laRSIsIlJFTkRFUkJVRkZFUl9CTFVFX1NJWkUiLCJSRU5ERVJCVUZGRVJfUkVEX1NJWkUiLCJSRU5ERVJCVUZGRVJfQUxQSEFfU0laRSIsIlJFTkRFUkJVRkZFUl9ERVBUSF9TSVpFIiwiUkVOREVSQlVGRkVSX1NURU5DSUxfU0laRSIsIlJFTkRFUkJVRkZFUl9TQU1QTEVTIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTs7OztBQUNBOztBQUVBOzs7Ozs7OztJQUVxQkEsWTs7OzZCQUVIQyxFLEVBQWlCO0FBQUEsVUFBYkMsTUFBYSx1RUFBSixFQUFJOztBQUMvQixhQUFPQSxrQkFBa0JGLFlBQWxCLEdBQWlDRSxNQUFqQztBQUNMO0FBQ0EsVUFBSUYsWUFBSixDQUFpQkMsRUFBakIsRUFBcUIsRUFBQ0UsUUFBUUQsT0FBT0MsTUFBUCxJQUFpQkQsTUFBMUIsRUFBckIsQ0FGRjtBQUdEOzs7QUFFRCx3QkFBWUQsRUFBWixFQUEyQjtBQUFBLFFBQVhHLElBQVcsdUVBQUosRUFBSTs7QUFBQTs7QUFDekIseUNBQW1CSCxFQUFuQjs7QUFFQSxTQUFLQSxFQUFMLEdBQVVBLEVBQVY7QUFDQSxTQUFLRSxNQUFMLEdBQWNGLEdBQUdJLGtCQUFILEVBQWQ7QUFDQSxRQUFJLENBQUMsS0FBS0YsTUFBVixFQUFrQjtBQUNoQixZQUFNLElBQUlHLEtBQUosQ0FBVSxxQ0FBVixDQUFOO0FBQ0Q7QUFDRjs7Ozs4QkFFUTtBQUNQLFdBQUtMLEVBQUwsQ0FBUU0sa0JBQVIsQ0FBMkIsS0FBS0osTUFBaEM7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzJCQUVNO0FBQ0wsV0FBS0YsRUFBTCxDQUFRTyxnQkFBUixDQUF5QixnQkFBR0MsWUFBNUIsRUFBMEMsS0FBS04sTUFBL0M7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzZCQUVRO0FBQ1AsV0FBS0YsRUFBTCxDQUFRTyxnQkFBUixDQUF5QixnQkFBR0MsWUFBNUIsRUFBMEMsSUFBMUM7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7Ozs7Ozs7Ozs7O2tDQVN5QztBQUFBLFVBQWhDQyxjQUFnQyxRQUFoQ0EsY0FBZ0M7QUFBQSxVQUFoQkMsS0FBZ0IsUUFBaEJBLEtBQWdCO0FBQUEsVUFBVEMsTUFBUyxRQUFUQSxNQUFTO0FBQUEsVUFDaENYLEVBRGdDLEdBQzFCLElBRDBCLENBQ2hDQSxFQURnQzs7QUFFdkMsNEJBQU9TLGNBQVAsRUFBdUIsc0JBQXZCO0FBQ0EsV0FBS0csSUFBTDtBQUNBWixTQUFHYSxtQkFBSCxDQUNFLGdCQUFHTCxZQURMLEVBQ21CLGtCQUFNQyxjQUFOLENBRG5CLEVBQzBDQyxLQUQxQyxFQUNpREMsTUFEakQ7QUFHQSxXQUFLRyxNQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7QUFDQTs7OztpQ0FDYUMsSyxFQUFPO0FBQUEsVUFDWGYsRUFEVyxHQUNMLElBREssQ0FDWEEsRUFEVzs7QUFFbEIsV0FBS1ksSUFBTDtBQUNBLFVBQU1JLFFBQ0poQixHQUFHaUIsd0JBQUgsQ0FBNEIsZ0JBQUdULFlBQS9CLEVBQTZDLGtCQUFNTyxLQUFOLENBQTdDLENBREY7QUFFQSxXQUFLRCxNQUFMO0FBQ0EsYUFBT0UsS0FBUDtBQUNEOztBQUVEOzs7Ozs7QUF3REE7O0FBRUE7eUNBTVE7QUFBQSxzRkFBSixFQUFJO0FBQUEsVUFKTkUsT0FJTSxTQUpOQSxPQUlNO0FBQUEsVUFITkMsY0FHTSxTQUhOQSxjQUdNO0FBQUEsVUFGTlQsS0FFTSxTQUZOQSxLQUVNO0FBQUEsVUFETkMsTUFDTSxTQUROQSxNQUNNOztBQUFBLFVBQ0NYLEVBREQsR0FDTyxJQURQLENBQ0NBLEVBREQ7O0FBRU4sNENBQW9CQSxFQUFwQjtBQUNBQSxTQUFHb0IsOEJBQUgsQ0FDRSxnQkFBR1osWUFETCxFQUNtQlUsT0FEbkIsRUFDNEJDLGNBRDVCLEVBQzRDVCxLQUQ1QyxFQUNtREMsTUFEbkQ7QUFHQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7OztzREFDZ0U7QUFBQSxVQUFwQ1EsY0FBb0MsU0FBcENBLGNBQW9DO0FBQUEsOEJBQXBCSixLQUFvQjtBQUFBLFVBQXBCQSxLQUFvQiwrQkFBWixTQUFZO0FBQUEsVUFDdkRmLEVBRHVELEdBQ2pELElBRGlELENBQ3ZEQSxFQUR1RDs7QUFFOUQsNENBQW9CQSxFQUFwQjtBQUNBLGFBQU9BLEdBQUdxQiwwQkFBSCxDQUNMLGdCQUFHYixZQURFLEVBQ1lXLGNBRFosRUFDNEJKLEtBRDVCLENBQVA7QUFHRDs7O3dCQS9FVztBQUNWLGFBQU8sS0FBS08sWUFBTCxDQUFrQixnQkFBR0Msa0JBQXJCLENBQVA7QUFDRDs7QUFFRDs7Ozt3QkFDYTtBQUNYLGFBQU8sS0FBS0QsWUFBTCxDQUFrQixnQkFBR0UsbUJBQXJCLENBQVA7QUFDRDs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozt3QkFDcUI7QUFDbkIsYUFBTyxLQUFLRixZQUFMLENBQWtCLGdCQUFHRyw0QkFBckIsQ0FBUDtBQUNEOztBQUVEOzs7O3dCQUNnQjtBQUNkLGFBQU8sS0FBS0gsWUFBTCxDQUFrQixnQkFBR0ksdUJBQXJCLENBQVA7QUFDRDs7QUFFRDs7Ozt3QkFDZTtBQUNiLGFBQU8sS0FBS0osWUFBTCxDQUFrQixnQkFBR0ssc0JBQXJCLENBQVA7QUFDRDs7QUFFRDs7Ozt3QkFDYztBQUNaLGFBQU8sS0FBS0wsWUFBTCxDQUFrQixnQkFBR00scUJBQXJCLENBQVA7QUFDRDs7QUFFRDs7Ozt3QkFDZ0I7QUFDZCxhQUFPLEtBQUtOLFlBQUwsQ0FBa0IsZ0JBQUdPLHVCQUFyQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7d0JBQ2dCO0FBQ2QsYUFBTyxLQUFLUCxZQUFMLENBQWtCLGdCQUFHUSx1QkFBckIsQ0FBUDtBQUNEOztBQUVEOzs7O3dCQUNrQjtBQUNoQixhQUFPLEtBQUtSLFlBQUwsQ0FBa0IsZ0JBQUdTLHlCQUFyQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7d0JBQ2M7QUFDWixhQUFPLEtBQUtULFlBQUwsQ0FBa0IsS0FBS3RCLEVBQUwsQ0FBUWdDLG9CQUExQixDQUFQO0FBQ0Q7Ozs7OztrQkF0SGtCakMsWSIsImZpbGUiOiJyZW5kZXJidWZmZXIuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgR0wsIHtnbEdldH0gZnJvbSAnLi93ZWJnbCc7XG5pbXBvcnQge2Fzc2VydFdlYkdMQ29udGV4dCwgYXNzZXJ0V2ViR0wyQ29udGV4dH0gZnJvbSAnLi93ZWJnbC1jaGVja3MnO1xuXG5pbXBvcnQgYXNzZXJ0IGZyb20gJ2Fzc2VydCc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFJlbmRlcmJ1ZmZlciB7XG5cbiAgc3RhdGljIG1ha2VGcm9tKGdsLCBvYmplY3QgPSB7fSkge1xuICAgIHJldHVybiBvYmplY3QgaW5zdGFuY2VvZiBSZW5kZXJidWZmZXIgPyBvYmplY3QgOlxuICAgICAgLy8gVXNlIC5oYW5kbGUgKGUuZyBmcm9tIHN0YWNrLmdsJ3MgZ2wtYnVmZmVyKSwgZWxzZSB1c2UgYnVmZmVyIGRpcmVjdGx5XG4gICAgICBuZXcgUmVuZGVyYnVmZmVyKGdsLCB7aGFuZGxlOiBvYmplY3QuaGFuZGxlIHx8IG9iamVjdH0pO1xuICB9XG5cbiAgY29uc3RydWN0b3IoZ2wsIG9wdHMgPSB7fSkge1xuICAgIGFzc2VydFdlYkdMQ29udGV4dChnbCk7XG5cbiAgICB0aGlzLmdsID0gZ2w7XG4gICAgdGhpcy5oYW5kbGUgPSBnbC5jcmVhdGVSZW5kZXJidWZmZXIoKTtcbiAgICBpZiAoIXRoaXMuaGFuZGxlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0ZhaWxlZCB0byBjcmVhdGUgV2ViR0wgUmVuZGVyYnVmZmVyJyk7XG4gICAgfVxuICB9XG5cbiAgZGVsZXRlKCkge1xuICAgIHRoaXMuZ2wuZGVsZXRlUmVuZGVyYnVmZmVyKHRoaXMuaGFuZGxlKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGJpbmQoKSB7XG4gICAgdGhpcy5nbC5iaW5kUmVuZGVyYnVmZmVyKEdMLlJFTkRFUkJVRkZFUiwgdGhpcy5oYW5kbGUpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgdW5iaW5kKCkge1xuICAgIHRoaXMuZ2wuYmluZFJlbmRlcmJ1ZmZlcihHTC5SRU5ERVJCVUZGRVIsIG51bGwpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYW5kIGluaXRpYWxpemVzIGEgcmVuZGVyYnVmZmVyIG9iamVjdCdzIGRhdGEgc3RvcmVcbiAgICpcbiAgICogQHBhcmFtIHtHTGVudW19IG9wdC5pbnRlcm5hbEZvcm1hdCAtXG4gICAqIEBwYXJhbSB7R0xpbnR9IG9wdC53aWR0aCAtXG4gICAqIEBwYXJhbSB7R0xpbnR9IG9wdC5oZWlnaHRcbiAgICogQHBhcmFtIHtCb29sZWFufSBvcHQuYXV0b2JpbmQ9dHJ1ZSAtIG1ldGhvZCBjYWxsIHdpbGwgYmluZC91bmJpbmQgb2JqZWN0XG4gICAqIEByZXR1cm5zIHtSZW5kZXJidWZmZXJ9IHJldHVybnMgaXRzZWxmIHRvIGVuYWJsZSBjaGFpbmluZ1xuICAgKi9cbiAgc3RvcmFnZSh7aW50ZXJuYWxGb3JtYXQsIHdpZHRoLCBoZWlnaHR9KSB7XG4gICAgY29uc3Qge2dsfSA9IHRoaXM7XG4gICAgYXNzZXJ0KGludGVybmFsRm9ybWF0LCAnTmVlZHMgaW50ZXJuYWxGb3JtYXQnKTtcbiAgICB0aGlzLmJpbmQoKTtcbiAgICBnbC5yZW5kZXJidWZmZXJTdG9yYWdlKFxuICAgICAgR0wuUkVOREVSQlVGRkVSLCBnbEdldChpbnRlcm5hbEZvcm1hdCksIHdpZHRoLCBoZWlnaHRcbiAgICApO1xuICAgIHRoaXMudW5iaW5kKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyBAcGFyYW0ge0Jvb2xlYW59IG9wdC5hdXRvYmluZD10cnVlIC0gbWV0aG9kIGNhbGwgd2lsbCBiaW5kL3VuYmluZCBvYmplY3RcbiAgLy8gQHJldHVybnMge0dMZW51bXxHTGludH0gLSBkZXBlbmRzIG9uIHBuYW1lXG4gIGdldFBhcmFtZXRlcihwbmFtZSkge1xuICAgIGNvbnN0IHtnbH0gPSB0aGlzO1xuICAgIHRoaXMuYmluZCgpO1xuICAgIGNvbnN0IHZhbHVlID1cbiAgICAgIGdsLmdldFJlbmRlcmJ1ZmZlclBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVIsIGdsR2V0KHBuYW1lKSk7XG4gICAgdGhpcy51bmJpbmQoKTtcbiAgICByZXR1cm4gdmFsdWU7XG4gIH1cblxuICAvLyBAcmV0dXJucyB7R0xpbnR9IC0gd2lkdGggb2YgdGhlIGltYWdlIG9mIHRoZSBjdXJyZW50bHkgYm91bmQgcmVuZGVyYnVmZmVyLlxuICBnZXQgd2lkdGgoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9XSURUSCk7XG4gIH1cblxuICAvLyBAcmV0dXJucyB7R0xpbnR9IC0gaGVpZ2h0IG9mIHRoZSBpbWFnZSBvZiB0aGUgY3VycmVudGx5IGJvdW5kIHJlbmRlcmJ1ZmZlci5cbiAgZ2V0IGhlaWdodCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRQYXJhbWV0ZXIoR0wuUkVOREVSQlVGRkVSX0hFSUdIVCk7XG4gIH1cblxuICAvLyBAcmV0dXJucyB7R0xlbnVtfSBpbnRlcm5hbCBmb3JtYXQgb2YgdGhlIGN1cnJlbnRseSBib3VuZCByZW5kZXJidWZmZXIuXG4gIC8vIFRoZSBkZWZhdWx0IGlzIGdsLlJHQkE0LiBQb3NzaWJsZSByZXR1cm4gdmFsdWVzOlxuICAvLyBnbC5SR0JBNDogNCByZWQgYml0cywgNCBncmVlbiBiaXRzLCA0IGJsdWUgYml0cyA0IGFscGhhIGJpdHMuXG4gIC8vIGdsLlJHQjU2NTogNSByZWQgYml0cywgNiBncmVlbiBiaXRzLCA1IGJsdWUgYml0cy5cbiAgLy8gZ2wuUkdCNV9BMTogNSByZWQgYml0cywgNSBncmVlbiBiaXRzLCA1IGJsdWUgYml0cywgMSBhbHBoYSBiaXQuXG4gIC8vIGdsLkRFUFRIX0NPTVBPTkVOVDE2OiAxNiBkZXB0aCBiaXRzLlxuICAvLyBnbC5TVEVOQ0lMX0lOREVYODogOCBzdGVuY2lsIGJpdHMuXG4gIGdldCBpbnRlcm5hbEZvcm1hdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRQYXJhbWV0ZXIoR0wuUkVOREVSQlVGRkVSX0lOVEVSTkFMX0ZPUk1BVCk7XG4gIH1cblxuICAvLyAgQHJldHVybnMge0dMaW50fSAtIHJlc29sdXRpb24gc2l6ZSAoaW4gYml0cykgZm9yIHRoZSBncmVlbiBjb2xvci5cbiAgZ2V0IGdyZWVuU2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRQYXJhbWV0ZXIoR0wuUkVOREVSQlVGRkVSX0dSRUVOX1NJWkUpO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMaW50fSAtIHJlc29sdXRpb24gc2l6ZSAoaW4gYml0cykgZm9yIHRoZSBibHVlIGNvbG9yLlxuICBnZXQgYmx1ZVNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9CTFVFX1NJWkUpO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMaW50fSAtIHJlc29sdXRpb24gc2l6ZSAoaW4gYml0cykgZm9yIHRoZSByZWQgY29sb3IuXG4gIGdldCByZWRTaXplKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVJfUkVEX1NJWkUpO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMaW50fSAtIHJlc29sdXRpb24gc2l6ZSAoaW4gYml0cykgZm9yIHRoZSBhbHBoYSBjb21wb25lbnQuXG4gIGdldCBhbHBoYVNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9BTFBIQV9TSVpFKTtcbiAgfVxuXG4gIC8vIEByZXR1cm5zIHtHTGludH0gLSByZXNvbHV0aW9uIHNpemUgKGluIGJpdHMpIGZvciB0aGUgZGVwdGggY29tcG9uZW50LlxuICBnZXQgZGVwdGhTaXplKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVJfREVQVEhfU0laRSk7XG4gIH1cblxuICAvLyBAcmV0dXJucyB7R0xpbnR9IC0gcmVzb2x1dGlvbiBzaXplIChpbiBiaXRzKSBmb3IgdGhlIHN0ZW5jaWwgY29tcG9uZW50LlxuICBnZXQgc3RlbmNpbFNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9TVEVOQ0lMX1NJWkUpO1xuICB9XG5cbiAgLy8gV2hlbiB1c2luZyBhIFdlYkdMIDIgY29udGV4dCwgdGhlIGZvbGxvd2luZyB2YWx1ZSBpcyBhdmFpbGFibGVcbiAgZ2V0IHNhbXBsZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKHRoaXMuZ2wuUkVOREVSQlVGRkVSX1NBTVBMRVMpO1xuICB9XG5cbiAgLy8gV0VCR0wyIE1FVEhPRFNcblxuICAvLyAoT3BlbkdMIEVTIDMuMC40IMKnNC40LjIpXG4gIHN0b3JhZ2VNdWx0aXNhbXBsZSh7XG4gICAgc2FtcGxlcyxcbiAgICBpbnRlcm5hbGZvcm1hdCxcbiAgICB3aWR0aCxcbiAgICBoZWlnaHRcbiAgfSA9IHt9KSB7XG4gICAgY29uc3Qge2dsfSA9IHRoaXM7XG4gICAgYXNzZXJ0V2ViR0wyQ29udGV4dChnbCk7XG4gICAgZ2wucmVuZGVyYnVmZmVyU3RvcmFnZU11bHRpc2FtcGxlKFxuICAgICAgR0wuUkVOREVSQlVGRkVSLCBzYW1wbGVzLCBpbnRlcm5hbGZvcm1hdCwgd2lkdGgsIGhlaWdodFxuICAgICk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyAoT3BlbkdMIEVTIDMuMC40IMKnNi4xLjE1KVxuICBnZXRJbnRlcm5hbGZvcm1hdFBhcmFtZXRlcih7aW50ZXJuYWxmb3JtYXQsIHBuYW1lID0gJ1NBTVBMRVMnfSkge1xuICAgIGNvbnN0IHtnbH0gPSB0aGlzO1xuICAgIGFzc2VydFdlYkdMMkNvbnRleHQoZ2wpO1xuICAgIHJldHVybiBnbC5nZXRJbnRlcm5hbGZvcm1hdFBhcmFtZXRlcihcbiAgICAgIEdMLlJFTkRFUkJVRkZFUiwgaW50ZXJuYWxmb3JtYXQsIHBuYW1lXG4gICAgKTtcbiAgfVxufVxuIl19