'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FragmentShader = exports.VertexShader = exports.Shader = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('./webgl');

var _webglChecks = require('./webgl-checks');

var _webglFormatGlslError = require('./webgl-format-glsl-error');

var _utils = require('../utils');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ERR_SOURCE = 'Shader: GLSL source code must be a JavaScript string';

// For now this is an internal class

var Shader = exports.Shader = function () {

  /* eslint-disable max-statements */
  function Shader(gl, source, shaderType) {
    _classCallCheck(this, Shader);

    (0, _webglChecks.assertWebGLContext)(gl);
    (0, _assert2.default)(typeof source === 'string', ERR_SOURCE);

    this.id = (0, _webglFormatGlslError.getShaderName)(source) || (0, _utils.uid)(this.getTypeName(shaderType));
    this.gl = gl;
    this.shaderType = shaderType;
    this.source = source;
    this.handle = gl.createShader(shaderType);
    if (this.handle === null) {
      throw new Error('Error creating shader with type ' + shaderType);
    }
    this.compile();
  }

  _createClass(Shader, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      if (this.handle) {
        gl.deleteShader(this.handle);
        this.handle = null;
      }
    }
  }, {
    key: 'toString',
    value: function toString() {
      return this.getTypeName(this.shaderType) + ':' + this.id;
    }
  }, {
    key: 'getName',
    value: function getName() {
      return (0, _webglFormatGlslError.getShaderName)(this.source);
    }
  }, {
    key: 'getTypeName',
    value: function getTypeName(shaderType) {
      switch (shaderType) {
        case _webgl.GL.VERTEX_SHADER:
          return 'vertex-shader';
        case _webgl.GL.FRAGMENT_SHADER:
          return 'fragment-shader';
        default:
          return 'shader';
      }
    }
  }, {
    key: 'compile',
    value: function compile() {
      var gl = this.gl;

      gl.shaderSource(this.handle, this.source);
      gl.compileShader(this.handle);

      // Shader compilation error is checked only when debug context is used
      if (gl.debug) {
        var compiled = gl.getShaderParameter(this.handle, _webgl.GL.COMPILE_STATUS);
        if (!compiled) {
          var infoLog = gl.getShaderInfoLog(this.handle);
          var error = (0, _webglFormatGlslError.formatGLSLCompilerError)(infoLog, this.source, this.shaderType);
          this.delete();
          throw new Error('Error while compiling the shader ' + error);
        }
      }
    }
    /* eslint-enable max-statements */

    // TODO - move to debug utils?

  }, {
    key: 'copyToClipboard',
    value: function copyToClipboard(text) {
      if (_utils.isBrowser) {
        /* global document */
        var input = document.createElement('textarea');
        document.body.appendChild(input);
        input.value = text;
        input.focus();
        input.select();
        if (!document.execCommand('copy')) {
          /* eslint-disable no-console */
          /* global console */
          console.log('Failed to copy to clipboard');
        }
        input.remove();
      }
    }
  }]);

  return Shader;
}();

var VertexShader = exports.VertexShader = function (_Shader) {
  _inherits(VertexShader, _Shader);

  function VertexShader(gl, source) {
    _classCallCheck(this, VertexShader);

    return _possibleConstructorReturn(this, (VertexShader.__proto__ || Object.getPrototypeOf(VertexShader)).call(this, gl, source, _webgl.GL.VERTEX_SHADER));
  }

  return VertexShader;
}(Shader);

var FragmentShader = exports.FragmentShader = function (_Shader2) {
  _inherits(FragmentShader, _Shader2);

  function FragmentShader(gl, source) {
    _classCallCheck(this, FragmentShader);

    return _possibleConstructorReturn(this, (FragmentShader.__proto__ || Object.getPrototypeOf(FragmentShader)).call(this, gl, source, _webgl.GL.FRAGMENT_SHADER));
  }

  return FragmentShader;
}(Shader);
//# sourceMappingURL=data:application/json;base64,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