'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); // WebGL2 Sync Object Helper
// https://developer.mozilla.org/en-US/docs/Web/API/WebGLQuery


var _webglChecks = require('../webgl/webgl-checks');

var _queryManager = require('./queryManager');

var _queryManager2 = _interopRequireDefault(_queryManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// WebGLSync? fenceSync(GLenum condition, GLbitfield flags);
// [WebGLHandlesContextLoss] GLboolean isSync(WebGLSync? sync);
// void deleteSync(WebGLSync? sync);
// GLenum clientWaitSync(WebGLSync? sync, GLbitfield flags, GLint64 timeout);
// void waitSync(WebGLSync? sync, GLbitfield flags, GLint64 timeout);
// any getSyncParameter(WebGLSync? sync, GLenum pname);

var Sync = function () {
  /**
   * @class
   * @param {WebGL2RenderingContext} gl
   */
  function Sync(gl) {
    _classCallCheck(this, Sync);

    (0, _webglChecks.assertWebGL2Context)(gl);

    var handle = gl.fenceSync(gl.SYNC_GPU_COMMANDS_COMPLETE, 0);
    (0, _webglChecks.glCheckError)(gl);

    this.gl = gl;
    this.handle = handle;
    this.userData = {};

    // query manager needs a promise field
    this.promise = null;

    Object.seal(this);
  }

  /**
   * @return {Sync} returns self to enable chaining
   */


  _createClass(Sync, [{
    key: 'delete',
    value: function _delete() {
      _queryManager2.default.deleteQuery(this);
      if (this.handle) {
        this.gl.deleteSync(this.handle);
        this.handle = null;
        (0, _webglChecks.glCheckError)(this.gl);
      }
      return this;
    }

    /**
     * @param {GLbitfield} flags
     * @param {GLint64} timeout
     * @return {Sync} returns self to enable chaining
     */

  }, {
    key: 'wait',
    value: function wait(flags, timeout) {
      this.gl.waitSync(this.handle, flags, timeout);
      (0, _webglChecks.glCheckError)(this.gl);
      return this;
    }

    /**
     * @param {GLbitfield} flags
     * @param {GLint64} timeout
     * @return {GLenum} result
     */

  }, {
    key: 'clientWait',
    value: function clientWait(flags, timeout) {
      var result = this.gl.clientWaitSync(this.handle, flags, timeout);
      (0, _webglChecks.glCheckError)(this.gl);
      return result;
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      _queryManager2.default.cancelQuery(this);
    }
  }, {
    key: 'isResultAvailable',
    value: function isResultAvailable() {
      var status = this.gl.getSyncParameter(this.handle, this.gl.SYNC_STATUS);
      return status === this.gl.SIGNALED;
    }
  }, {
    key: 'getResult',
    value: function getResult() {
      return this.gl.SIGNALED;
    }
  }]);

  return Sync;
}();

exports.default = Sync;
//# sourceMappingURL=data:application/json;base64,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