'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('./webgl');

var _webglChecks = require('./webgl-checks');

var _texture = require('./texture');

var _texture2 = _interopRequireDefault(_texture);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectDestructuringEmpty(obj) { if (obj == null) throw new TypeError("Cannot destructure undefined"); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Texture2D = function (_Texture) {
  _inherits(Texture2D, _Texture);

  _createClass(Texture2D, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Texture2D ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Texture2D(gl, { handle: object.handle || object });
    }
  }, {
    key: 'makeFromSolidColor',
    value: function makeFromSolidColor(gl, _ref) {
      var _ref2 = _slicedToArray(_ref, 4),
          _ref2$ = _ref2[0],
          r = _ref2$ === undefined ? 0 : _ref2$,
          _ref2$2 = _ref2[1],
          g = _ref2$2 === undefined ? 0 : _ref2$2,
          _ref2$3 = _ref2[2],
          b = _ref2$3 === undefined ? 0 : _ref2$3,
          _ref2$4 = _ref2[3],
          a = _ref2$4 === undefined ? 1 : _ref2$4;

      return new Texture2D(gl, {
        pixels: new Uint8Array([r, g, b, a]),
        width: 1,
        format: gl.RGBA,
        magFilter: gl.NEAREST,
        minFilter: gl.NEAREST
      });
    }
  }, {
    key: 'makeFromPixelArray',
    value: function makeFromPixelArray(gl, opts) {
      var dataArray = opts.dataArray,
          _opts$format = opts.format,
          format = _opts$format === undefined ? _webgl.GL.RGBA : _opts$format,
          _opts$width = opts.width,
          width = _opts$width === undefined ? 1 : _opts$width,
          height = opts.height;
      // Don't need to do this if the data is already in a typed array

      var dataTypedArray = new Uint8Array(dataArray);
      return new Texture2D(gl, Object.assign({
        pixels: dataTypedArray,
        width: width,
        height: height,
        format: format
      }, opts));
    }

    /**
     * @classdesc
     * 2D WebGL Texture
     * Note: Constructor will initialize your texture.
     *
     * @class
     * @param {WebGLRenderingContext} gl - gl context
     * @param {Image|ArrayBuffer|null} opts= - named options
     * @param {Image|ArrayBuffer|null} opts.data= - buffer
     * @param {GLint} width - width of texture
     * @param {GLint} height - height of texture
     */

  }]);

  function Texture2D(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Texture2D);

    (0, _webglChecks.assertWebGLContext)(gl);

    var _this = _possibleConstructorReturn(this, (Texture2D.__proto__ || Object.getPrototypeOf(Texture2D)).call(this, gl, Object.assign({}, opts, { target: gl.TEXTURE_2D })));

    _this.width = null;
    _this.height = null;
    Object.seal(_this);

    _this.setImageData(opts);
    if (opts.generateMipmap) {
      _this.generateMipmap();
    }
    return _this;
  }

  // target cannot be modified by bind:
  // textures are special because when you first bind them to a target,
  // they get special information. When you first bind a texture as a
  // GL_TEXTURE_2D, you are actually setting special state in the texture.
  // You are saying that this texture is a 2D texture.
  // And it will always be a 2D texture; this state cannot be changed ever.
  // If you have a texture that was first bound as a GL_TEXTURE_2D,
  // you must always bind it as a GL_TEXTURE_2D;
  // attempting to bind it as GL_TEXTURE_1D will give rise to an error
  // (while run-time).

  _createClass(Texture2D, [{
    key: 'bind',
    value: function bind() {
      var textureUnit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.textureUnit;
      var gl = this.gl;

      if (textureUnit === undefined) {
        throw new Error('Texture.bind: must specify texture unit');
      }
      this.textureUnit = textureUnit;
      gl.activeTexture(gl.TEXTURE0 + textureUnit);
      gl.bindTexture(this.target, this.handle);
      return textureUnit;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var gl = this.gl;

      if (this.textureUnit === undefined) {
        throw new Error('Texture.unbind: texture unit not specified');
      }
      gl.activeTexture(gl.TEXTURE0 + this.textureUnit);
      gl.bindTexture(this.target, null);
      return this.textureUnit;
    }
  }, {
    key: 'getActiveUnit',
    value: function getActiveUnit() {
      return this.gl.getParameter(_webgl.GL.ACTIVE_TEXTURE) - _webgl.GL.TEXTURE0;
    }

    // WebGL2

  }, {
    key: 'setPixels',
    value: function setPixels() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var buffer = opts.buffer,
          _opts$width2 = opts.width,
          width = _opts$width2 === undefined ? null : _opts$width2,
          _opts$height = opts.height,
          height = _opts$height === undefined ? null : _opts$height,
          _opts$mipmapLevel = opts.mipmapLevel,
          mipmapLevel = _opts$mipmapLevel === undefined ? 0 : _opts$mipmapLevel,
          _opts$format2 = opts.format,
          format = _opts$format2 === undefined ? _webgl.GL.RGBA : _opts$format2,
          _opts$type = opts.type,
          type = _opts$type === undefined ? _webgl.GL.UNSIGNED_BYTE : _opts$type,
          _opts$border = opts.border,
          border = _opts$border === undefined ? 0 : _opts$border;
      var gl = this.gl;

      // This signature of texImage2D uses currently bound GL_PIXEL_UNPACK_BUFFER

      gl.bindBuffer(_webgl.GL.PIXEL_UNPACK_BUFFER, buffer.target);
      // And as always, we must also bind the texture itself
      this.bind();

      gl.texImage2D(gl.TEXTURE_2D, mipmapLevel, format, width, height, border, format, type, buffer.target);

      this.unbind();
      gl.bindBuffer(_webgl.GL.GL_PIXEL_UNPACK_BUFFER, null);
      return this;
    }
  }, {
    key: 'setImageDataFromCompressedBuffer',
    value: function setImageDataFromCompressedBuffer(opts) {
      var buffer = opts.buffer,
          _opts$width3 = opts.width,
          width = _opts$width3 === undefined ? null : _opts$width3,
          _opts$height2 = opts.height,
          height = _opts$height2 === undefined ? null : _opts$height2,
          _opts$mipmapLevel2 = opts.mipmapLevel,
          mipmapLevel = _opts$mipmapLevel2 === undefined ? 0 : _opts$mipmapLevel2,
          _opts$internalFormat = opts.internalFormat,
          internalFormat = _opts$internalFormat === undefined ? _webgl.GL.RGBA : _opts$internalFormat,
          _opts$border2 = opts.border,
          border = _opts$border2 === undefined ? 0 : _opts$border2;
      var gl = this.gl;

      gl.compressedTexImage2D(this.target, mipmapLevel, internalFormat, width, height, border, buffer);
      // gl.compressedTexSubImage2D(target,
      //   level, xoffset, yoffset, width, height, format, ArrayBufferView? pixels);
      return this;
    }

    /**
     * Defines a two-dimensional texture image or cube-map texture image with
     * pixels from the current framebuffer (rather than from client memory).
     * (gl.copyTexImage2D wrapper)
     */

  }, {
    key: 'copyImageFromFramebuffer',
    value: function copyImageFromFramebuffer(opts) {
      var framebuffer = opts.framebuffer,
          x = opts.x,
          y = opts.y,
          width = opts.width,
          height = opts.height,
          _opts$mipmapLevel3 = opts.mipmapLevel,
          mipmapLevel = _opts$mipmapLevel3 === undefined ? 0 : _opts$mipmapLevel3,
          _opts$internalFormat2 = opts.internalFormat,
          internalFormat = _opts$internalFormat2 === undefined ? _webgl.GL.RGBA : _opts$internalFormat2,
          _opts$border3 = opts.border,
          border = _opts$border3 === undefined ? 0 : _opts$border3;
      var gl = this.gl;

      framebuffer.bind();

      // target
      this.bind();
      gl.copyTexImage2D(this.target, mipmapLevel, internalFormat, x, y, width, height, border);
      this.unbind();

      framebuffer.unbind();
    }
  }, {
    key: 'copySubImage',
    value: function copySubImage(opts) {
      _objectDestructuringEmpty(opts);

      // if (pixels instanceof ArrayBufferView) {
      //   gl.texSubImage2D(target, level, x, y, width, height, format, type, pixels);
      // }
      // gl.texSubImage2D(target, level, x, y, format, type, ? pixels);
      // gl.texSubImage2D(target, level, x, y, format, type, HTMLImageElement pixels);
      // gl.texSubImage2D(target, level, x, y, format, type, HTMLCanvasElement pixels);
      // gl.texSubImage2D(target, level, x, y, format, type, HTMLVideoElement pixels);
      // // Additional signature in a WebGL 2 context:
      // gl.texSubImage2D(target, level, x, y, format, type, GLintptr offset);

    }
  }]);

  return Texture2D;
}(_texture2.default);

exports.default = Texture2D;
//# sourceMappingURL=data:application/json;base64,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