'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('./webgl');

var _webglChecks = require('./webgl-checks');

var _texture = require('./texture');

var _texture2 = _interopRequireDefault(_texture);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TextureCube = function (_Texture) {
  _inherits(TextureCube, _Texture);

  _createClass(TextureCube, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof TextureCube ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new TextureCube(gl, { handle: object.handle || object });
    }
  }]);

  function TextureCube(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, TextureCube);

    (0, _webglChecks.assertWebGLContext)(gl);

    var _this = _possibleConstructorReturn(this, (TextureCube.__proto__ || Object.getPrototypeOf(TextureCube)).call(this, gl, Object.assign({}, opts, { target: _webgl.GL.TEXTURE_CUBE_MAP })));

    _this.setCubeMapImageData(opts);
    return _this;
  }

  _createClass(TextureCube, [{
    key: 'bind',
    value: function bind() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          index = _ref.index;

      var gl = this.gl;

      if (index !== undefined) {
        gl.activeTexture(_webgl.GL.TEXTURE0 + index);
      }
      gl.bindTexture(_webgl.GL.TEXTURE_CUBE_MAP, this.handle);
      if (index === undefined) {
        var result = gl.getParameter(gl.ACTIVE_TEXTURE) - _webgl.GL.TEXTURE0;
        return result;
      }
      return index;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var gl = this.gl;

      gl.bindTexture(_webgl.GL.TEXTURE_CUBE_MAP, null);
    }

    /* eslint-disable max-statements, max-len */

  }, {
    key: 'setCubeMapImageData',
    value: function setCubeMapImageData(_ref2) {
      var width = _ref2.width,
          height = _ref2.height,
          pixels = _ref2.pixels,
          data = _ref2.data,
          _ref2$border = _ref2.border,
          border = _ref2$border === undefined ? 0 : _ref2$border,
          _ref2$format = _ref2.format,
          format = _ref2$format === undefined ? _webgl.GL.RGBA : _ref2$format,
          _ref2$type = _ref2.type,
          type = _ref2$type === undefined ? _webgl.GL.UNSIGNED_BYTE : _ref2$type,
          _ref2$generateMipmap = _ref2.generateMipmap,
          generateMipmap = _ref2$generateMipmap === undefined ? false : _ref2$generateMipmap;
      var gl = this.gl;

      pixels = pixels || data;
      this.bind();
      if (this.width || this.height) {
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_POSITIVE_X, 0, format, width, height, border, format, type, pixels.pos.x);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_POSITIVE_Y, 0, format, width, height, border, format, type, pixels.pos.y);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_POSITIVE_Z, 0, format, width, height, border, format, type, pixels.pos.z);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_NEGATIVE_X, 0, format, width, height, border, format, type, pixels.neg.x);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_NEGATIVE_Y, 0, format, width, height, border, format, type, pixels.neg.y);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_NEGATIVE_Z, 0, format, width, height, border, format, type, pixels.neg.z);
      } else {
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_POSITIVE_X, 0, format, format, type, pixels.pos.x);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_POSITIVE_Y, 0, format, format, type, pixels.pos.y);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_POSITIVE_Z, 0, format, format, type, pixels.pos.z);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_NEGATIVE_X, 0, format, format, type, pixels.neg.x);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_NEGATIVE_Y, 0, format, format, type, pixels.neg.y);
        gl.texImage2D(_webgl.GL.TEXTURE_CUBE_MAP_NEGATIVE_Z, 0, format, format, type, pixels.neg.z);
      }

      this.unbind();

      if (generateMipmap) {
        this.generateMipmap();
      }
      return this;
    }
  }]);

  return TextureCube;
}(_texture2.default);

exports.default = TextureCube;
//# sourceMappingURL=data:application/json;base64,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