'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); // WebGL2 Transform Feedback Helper
// https://developer.mozilla.org/en-US/docs/Web/API/WebGLQuery

var _webglTypes = require('./webgl-types');

var _context = require('../context');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* eslint-disable max-len */
// void bindTransformFeedback (GLenum target, WebGLTransformFeedback? id);
// void beginTransformFeedback(GLenum primitiveMode);
// void endTransformFeedback();
// void transformFeedbackVaryings(WebGLProgram? program, sequence<DOMString> varyings, GLenum bufferMode);
// WebGLActiveInfo? getTransformFeedbackVarying(WebGLProgram? program, GLuint index);
// void pauseTransformFeedback();
// void resumeTransformFeedback();

var TranformFeedback = function () {

  /**
   * @class
   * @param {WebGL2RenderingContext} gl
   */
  function TranformFeedback(gl) {
    _classCallCheck(this, TranformFeedback);

    (0, _assert2.default)(gl instanceof _webglTypes.WebGL2RenderingContext);
    this.gl = gl;
    this.handle = gl.createTransformFeedback();
    this.userData = {};
    Object.seal(this);
  }

  /**
   * @param {GLenum} target
   * @return {TransformFeedback} returns self to enable chaining
   */


  _createClass(TranformFeedback, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      gl.deleteTransformFeedback(this.handle);
      this.handle = null;
      (0, _context.glCheckError)(gl);
      return this;
    }

    /**
     * @param {GLenum} target
     * @return {TransformFeedback} returns self to enable chaining
     */

  }, {
    key: 'bind',
    value: function bind(target) {
      var gl = this.gl;

      gl.bindTransformFeedback(target, this.handle);
      (0, _context.glCheckError)(gl);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind(target) {
      var gl = this.gl;

      gl.bindTransformFeedback(target, null);
      (0, _context.glCheckError)(gl);
      return this;
    }

    /**
     * @param {GLenum} primitiveMode
     * @return {TransformFeedback} returns self to enable chaining
     */

  }, {
    key: 'begin',
    value: function begin(primitiveMode) {
      var gl = this.gl;

      gl.beginTransformFeedback(primitiveMode);
      (0, _context.glCheckError)(gl);
      return this;
    }

    /**
     * @return {TransformFeedback} returns self to enable chaining
     */

  }, {
    key: 'pause',
    value: function pause() {
      var gl = this.gl;

      gl.pauseTransformFeedback();
      (0, _context.glCheckError)(gl);
      return this;
    }

    /**
     * @return {TransformFeedback} returns self to enable chaining
     */

  }, {
    key: 'resume',
    value: function resume() {
      var gl = this.gl;

      gl.resumeTransformFeedback();
      (0, _context.glCheckError)(gl);
      return this;
    }

    /**
     * @return {TransformFeedback} returns self to enable chaining
     */

  }, {
    key: 'end',
    value: function end() {
      var gl = this.gl;

      gl.endTransformFeedback();
      (0, _context.glCheckError)(gl);
      return this;
    }

    /**
     * @param {WebGLProgram?} program
     * @param {sequence<DOMString>} varyings
     * @param {GLenum} bufferMode
     * @return {TransformFeedback} returns self to enable chaining
     */

  }, {
    key: 'varyings',
    value: function varyings(program, _varyings, bufferMode) {
      var gl = this.gl;

      var result = gl.transformFeedbackVaryings(program, _varyings, bufferMode);
      (0, _context.glCheckError)(gl);
      return result;
    }

    /**
     * @param {WebGLProgram} program
     * @param {GLuint} index
     * @return {WebGLActiveInfo} - object with {name, size, type}
     */

  }, {
    key: 'getVarying',
    value: function getVarying(program, index) {
      var gl = this.gl;

      var result = gl.getTransformFeedbackVarying(program, index);
      (0, _context.glCheckError)(gl);
      return result;
    }
  }]);

  return TranformFeedback;
}();

exports.default = TranformFeedback;
//# sourceMappingURL=data:application/json;base64,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