'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); // WebGL2 VertexArray Objects Helper


exports.isVertexArray = isVertexArray;

var _webglTypes = require('../webgl/webgl-types');

var _webglChecks = require('../webgl/webgl-checks');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* eslint-disable camelcase */
var OES_vertex_array_object = 'OES_vertex_array_object';

var VertexArrayObject = function () {
  _createClass(VertexArrayObject, null, [{
    key: 'isSupported',


    // Returns true if VertexArrayObject is supported by implementation
    value: function isSupported(gl) {
      (0, _webglChecks.assertWebGLContext)(gl);
      return gl instanceof _webglTypes.WebGL2RenderingContext || gl.getExtension('OES_vertex_array_object');
    }

    // Wraps a WebGLVertexArrayObject in a VertexArrayObject

  }, {
    key: 'wrap',
    value: function wrap(gl, object) {
      return object instanceof VertexArrayObject ? object : new VertexArrayObject(gl, { handle: object.handle || object });
    }

    // Create a VertexArrayObject

  }]);

  function VertexArrayObject(gl) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        handle = _ref.handle;

    _classCallCheck(this, VertexArrayObject);

    (0, _webglChecks.assertWebGLContext)(gl);
    (0, _assert2.default)(VertexArrayObject.isSupported(gl), 'VertexArrayObject: WebGL2 or OES_vertex_array_object required');

    handle = handle || createVertexArray(gl);
    // TODO isVertexArray fails when using extension for some reason
    // if (!isVertexArray(gl, handle)) {
    if (!handle) {
      throw new Error('Could not create VertexArrayObject');
    }

    this.gl = gl;
    this.handle = handle;
    this.userData = {};
    Object.seal(this);
  }

  _createClass(VertexArrayObject, [{
    key: 'delete',
    value: function _delete() {
      deleteVertexArray(this.gl, this.handle);
      return this;
    }
  }, {
    key: 'bind',
    value: function bind() {
      bindVertexArray(this.gl, this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      bindVertexArray(this.gl, null);
      return this;
    }
  }]);

  return VertexArrayObject;
}();

exports.default = VertexArrayObject;


function createVertexArray(gl) {
  if (gl instanceof _webglTypes.WebGL2RenderingContext) {
    return gl.createVertexArray();
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    return ext.createVertexArrayOES();
  }
  return null;
}

function deleteVertexArray(gl, vertexArray) {
  if (gl instanceof _webglTypes.WebGL2RenderingContext) {
    gl.deleteVertexArray(vertexArray);
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    ext.deleteVertexArrayOES(vertexArray);
  }
}

function isVertexArray(gl, vertexArray) {
  if (gl instanceof _webglTypes.WebGL2RenderingContext) {
    return gl.isVertexArray(vertexArray);
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    return ext.isVertexArrayOES(vertexArray);
  }
  return false;
}

function bindVertexArray(gl, vertexArray) {
  if (gl instanceof _webglTypes.WebGL2RenderingContext) {
    gl.bindVertexArray(vertexArray);
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    ext.bindVertexArrayOES(vertexArray);
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWJnbC92ZXJ0ZXgtYXJyYXktb2JqZWN0LmpzIl0sIm5hbWVzIjpbImlzVmVydGV4QXJyYXkiLCJPRVNfdmVydGV4X2FycmF5X29iamVjdCIsIlZlcnRleEFycmF5T2JqZWN0IiwiZ2wiLCJnZXRFeHRlbnNpb24iLCJvYmplY3QiLCJoYW5kbGUiLCJpc1N1cHBvcnRlZCIsImNyZWF0ZVZlcnRleEFycmF5IiwiRXJyb3IiLCJ1c2VyRGF0YSIsIk9iamVjdCIsInNlYWwiLCJkZWxldGVWZXJ0ZXhBcnJheSIsImJpbmRWZXJ0ZXhBcnJheSIsImV4dCIsImNyZWF0ZVZlcnRleEFycmF5T0VTIiwidmVydGV4QXJyYXkiLCJkZWxldGVWZXJ0ZXhBcnJheU9FUyIsImlzVmVydGV4QXJyYXlPRVMiLCJiaW5kVmVydGV4QXJyYXlPRVMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7cWpCQUFBOzs7UUFrRmdCQSxhLEdBQUFBLGE7O0FBakZoQjs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFFQTtBQUNBLElBQU1DLDBCQUEwQix5QkFBaEM7O0lBRXFCQyxpQjs7Ozs7QUFFbkI7Z0NBQ21CQyxFLEVBQUk7QUFDckIsMkNBQW1CQSxFQUFuQjtBQUNBLGFBQ0VBLG9EQUNBQSxHQUFHQyxZQUFILENBQWdCLHlCQUFoQixDQUZGO0FBSUQ7O0FBRUQ7Ozs7eUJBQ1lELEUsRUFBSUUsTSxFQUFRO0FBQ3RCLGFBQU9BLGtCQUFrQkgsaUJBQWxCLEdBQ0xHLE1BREssR0FFTCxJQUFJSCxpQkFBSixDQUFzQkMsRUFBdEIsRUFBMEIsRUFBQ0csUUFBUUQsT0FBT0MsTUFBUCxJQUFpQkQsTUFBMUIsRUFBMUIsQ0FGRjtBQUdEOztBQUVEOzs7O0FBQ0EsNkJBQVlGLEVBQVosRUFBK0I7QUFBQSxtRkFBSixFQUFJO0FBQUEsUUFBZEcsTUFBYyxRQUFkQSxNQUFjOztBQUFBOztBQUM3Qix5Q0FBbUJILEVBQW5CO0FBQ0EsMEJBQU9ELGtCQUFrQkssV0FBbEIsQ0FBOEJKLEVBQTlCLENBQVAsRUFDRSwrREFERjs7QUFHQUcsYUFBU0EsVUFBVUUsa0JBQWtCTCxFQUFsQixDQUFuQjtBQUNBO0FBQ0E7QUFDQSxRQUFJLENBQUNHLE1BQUwsRUFBYTtBQUNYLFlBQU0sSUFBSUcsS0FBSixDQUFVLG9DQUFWLENBQU47QUFDRDs7QUFFRCxTQUFLTixFQUFMLEdBQVVBLEVBQVY7QUFDQSxTQUFLRyxNQUFMLEdBQWNBLE1BQWQ7QUFDQSxTQUFLSSxRQUFMLEdBQWdCLEVBQWhCO0FBQ0FDLFdBQU9DLElBQVAsQ0FBWSxJQUFaO0FBQ0Q7Ozs7OEJBRVE7QUFDUEMsd0JBQWtCLEtBQUtWLEVBQXZCLEVBQTJCLEtBQUtHLE1BQWhDO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OzsyQkFFTTtBQUNMUSxzQkFBZ0IsS0FBS1gsRUFBckIsRUFBeUIsS0FBS0csTUFBOUI7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzZCQUVRO0FBQ1BRLHNCQUFnQixLQUFLWCxFQUFyQixFQUF5QixJQUF6QjtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7Ozs7a0JBbERrQkQsaUI7OztBQXFEckIsU0FBU00saUJBQVQsQ0FBMkJMLEVBQTNCLEVBQStCO0FBQzdCLE1BQUlBLGdEQUFKLEVBQTBDO0FBQ3hDLFdBQU9BLEdBQUdLLGlCQUFILEVBQVA7QUFDRDtBQUNELE1BQU1PLE1BQU1aLEdBQUdDLFlBQUgsQ0FBZ0JILHVCQUFoQixDQUFaO0FBQ0EsTUFBSWMsR0FBSixFQUFTO0FBQ1AsV0FBT0EsSUFBSUMsb0JBQUosRUFBUDtBQUNEO0FBQ0QsU0FBTyxJQUFQO0FBQ0Q7O0FBRUQsU0FBU0gsaUJBQVQsQ0FBMkJWLEVBQTNCLEVBQStCYyxXQUEvQixFQUE0QztBQUMxQyxNQUFJZCxnREFBSixFQUEwQztBQUN4Q0EsT0FBR1UsaUJBQUgsQ0FBcUJJLFdBQXJCO0FBQ0Q7QUFDRCxNQUFNRixNQUFNWixHQUFHQyxZQUFILENBQWdCSCx1QkFBaEIsQ0FBWjtBQUNBLE1BQUljLEdBQUosRUFBUztBQUNQQSxRQUFJRyxvQkFBSixDQUF5QkQsV0FBekI7QUFDRDtBQUNGOztBQUVNLFNBQVNqQixhQUFULENBQXVCRyxFQUF2QixFQUEyQmMsV0FBM0IsRUFBd0M7QUFDN0MsTUFBSWQsZ0RBQUosRUFBMEM7QUFDeEMsV0FBT0EsR0FBR0gsYUFBSCxDQUFpQmlCLFdBQWpCLENBQVA7QUFDRDtBQUNELE1BQU1GLE1BQU1aLEdBQUdDLFlBQUgsQ0FBZ0JILHVCQUFoQixDQUFaO0FBQ0EsTUFBSWMsR0FBSixFQUFTO0FBQ1AsV0FBT0EsSUFBSUksZ0JBQUosQ0FBcUJGLFdBQXJCLENBQVA7QUFDRDtBQUNELFNBQU8sS0FBUDtBQUNEOztBQUVELFNBQVNILGVBQVQsQ0FBeUJYLEVBQXpCLEVBQTZCYyxXQUE3QixFQUEwQztBQUN4QyxNQUFJZCxnREFBSixFQUEwQztBQUN4Q0EsT0FBR1csZUFBSCxDQUFtQkcsV0FBbkI7QUFDRDtBQUNELE1BQU1GLE1BQU1aLEdBQUdDLFlBQUgsQ0FBZ0JILHVCQUFoQixDQUFaO0FBQ0EsTUFBSWMsR0FBSixFQUFTO0FBQ1BBLFFBQUlLLGtCQUFKLENBQXVCSCxXQUF2QjtBQUNEO0FBQ0YiLCJmaWxlIjoidmVydGV4LWFycmF5LW9iamVjdC5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8vIFdlYkdMMiBWZXJ0ZXhBcnJheSBPYmplY3RzIEhlbHBlclxuaW1wb3J0IHtXZWJHTDJSZW5kZXJpbmdDb250ZXh0fSBmcm9tICcuLi93ZWJnbC93ZWJnbC10eXBlcyc7XG5pbXBvcnQge2Fzc2VydFdlYkdMQ29udGV4dH0gZnJvbSAnLi4vd2ViZ2wvd2ViZ2wtY2hlY2tzJztcbmltcG9ydCBhc3NlcnQgZnJvbSAnYXNzZXJ0JztcblxuLyogZXNsaW50LWRpc2FibGUgY2FtZWxjYXNlICovXG5jb25zdCBPRVNfdmVydGV4X2FycmF5X29iamVjdCA9ICdPRVNfdmVydGV4X2FycmF5X29iamVjdCc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFZlcnRleEFycmF5T2JqZWN0IHtcblxuICAvLyBSZXR1cm5zIHRydWUgaWYgVmVydGV4QXJyYXlPYmplY3QgaXMgc3VwcG9ydGVkIGJ5IGltcGxlbWVudGF0aW9uXG4gIHN0YXRpYyBpc1N1cHBvcnRlZChnbCkge1xuICAgIGFzc2VydFdlYkdMQ29udGV4dChnbCk7XG4gICAgcmV0dXJuIChcbiAgICAgIGdsIGluc3RhbmNlb2YgV2ViR0wyUmVuZGVyaW5nQ29udGV4dCB8fFxuICAgICAgZ2wuZ2V0RXh0ZW5zaW9uKCdPRVNfdmVydGV4X2FycmF5X29iamVjdCcpXG4gICAgKTtcbiAgfVxuXG4gIC8vIFdyYXBzIGEgV2ViR0xWZXJ0ZXhBcnJheU9iamVjdCBpbiBhIFZlcnRleEFycmF5T2JqZWN0XG4gIHN0YXRpYyB3cmFwKGdsLCBvYmplY3QpIHtcbiAgICByZXR1cm4gb2JqZWN0IGluc3RhbmNlb2YgVmVydGV4QXJyYXlPYmplY3QgP1xuICAgICAgb2JqZWN0IDpcbiAgICAgIG5ldyBWZXJ0ZXhBcnJheU9iamVjdChnbCwge2hhbmRsZTogb2JqZWN0LmhhbmRsZSB8fCBvYmplY3R9KTtcbiAgfVxuXG4gIC8vIENyZWF0ZSBhIFZlcnRleEFycmF5T2JqZWN0XG4gIGNvbnN0cnVjdG9yKGdsLCB7aGFuZGxlfSA9IHt9KSB7XG4gICAgYXNzZXJ0V2ViR0xDb250ZXh0KGdsKTtcbiAgICBhc3NlcnQoVmVydGV4QXJyYXlPYmplY3QuaXNTdXBwb3J0ZWQoZ2wpLFxuICAgICAgJ1ZlcnRleEFycmF5T2JqZWN0OiBXZWJHTDIgb3IgT0VTX3ZlcnRleF9hcnJheV9vYmplY3QgcmVxdWlyZWQnKTtcblxuICAgIGhhbmRsZSA9IGhhbmRsZSB8fCBjcmVhdGVWZXJ0ZXhBcnJheShnbCk7XG4gICAgLy8gVE9ETyBpc1ZlcnRleEFycmF5IGZhaWxzIHdoZW4gdXNpbmcgZXh0ZW5zaW9uIGZvciBzb21lIHJlYXNvblxuICAgIC8vIGlmICghaXNWZXJ0ZXhBcnJheShnbCwgaGFuZGxlKSkge1xuICAgIGlmICghaGFuZGxlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0NvdWxkIG5vdCBjcmVhdGUgVmVydGV4QXJyYXlPYmplY3QnKTtcbiAgICB9XG5cbiAgICB0aGlzLmdsID0gZ2w7XG4gICAgdGhpcy5oYW5kbGUgPSBoYW5kbGU7XG4gICAgdGhpcy51c2VyRGF0YSA9IHt9O1xuICAgIE9iamVjdC5zZWFsKHRoaXMpO1xuICB9XG5cbiAgZGVsZXRlKCkge1xuICAgIGRlbGV0ZVZlcnRleEFycmF5KHRoaXMuZ2wsIHRoaXMuaGFuZGxlKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGJpbmQoKSB7XG4gICAgYmluZFZlcnRleEFycmF5KHRoaXMuZ2wsIHRoaXMuaGFuZGxlKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHVuYmluZCgpIHtcbiAgICBiaW5kVmVydGV4QXJyYXkodGhpcy5nbCwgbnVsbCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cbn1cblxuZnVuY3Rpb24gY3JlYXRlVmVydGV4QXJyYXkoZ2wpIHtcbiAgaWYgKGdsIGluc3RhbmNlb2YgV2ViR0wyUmVuZGVyaW5nQ29udGV4dCkge1xuICAgIHJldHVybiBnbC5jcmVhdGVWZXJ0ZXhBcnJheSgpO1xuICB9XG4gIGNvbnN0IGV4dCA9IGdsLmdldEV4dGVuc2lvbihPRVNfdmVydGV4X2FycmF5X29iamVjdCk7XG4gIGlmIChleHQpIHtcbiAgICByZXR1cm4gZXh0LmNyZWF0ZVZlcnRleEFycmF5T0VTKCk7XG4gIH1cbiAgcmV0dXJuIG51bGw7XG59XG5cbmZ1bmN0aW9uIGRlbGV0ZVZlcnRleEFycmF5KGdsLCB2ZXJ0ZXhBcnJheSkge1xuICBpZiAoZ2wgaW5zdGFuY2VvZiBXZWJHTDJSZW5kZXJpbmdDb250ZXh0KSB7XG4gICAgZ2wuZGVsZXRlVmVydGV4QXJyYXkodmVydGV4QXJyYXkpO1xuICB9XG4gIGNvbnN0IGV4dCA9IGdsLmdldEV4dGVuc2lvbihPRVNfdmVydGV4X2FycmF5X29iamVjdCk7XG4gIGlmIChleHQpIHtcbiAgICBleHQuZGVsZXRlVmVydGV4QXJyYXlPRVModmVydGV4QXJyYXkpO1xuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1ZlcnRleEFycmF5KGdsLCB2ZXJ0ZXhBcnJheSkge1xuICBpZiAoZ2wgaW5zdGFuY2VvZiBXZWJHTDJSZW5kZXJpbmdDb250ZXh0KSB7XG4gICAgcmV0dXJuIGdsLmlzVmVydGV4QXJyYXkodmVydGV4QXJyYXkpO1xuICB9XG4gIGNvbnN0IGV4dCA9IGdsLmdldEV4dGVuc2lvbihPRVNfdmVydGV4X2FycmF5X29iamVjdCk7XG4gIGlmIChleHQpIHtcbiAgICByZXR1cm4gZXh0LmlzVmVydGV4QXJyYXlPRVModmVydGV4QXJyYXkpO1xuICB9XG4gIHJldHVybiBmYWxzZTtcbn1cblxuZnVuY3Rpb24gYmluZFZlcnRleEFycmF5KGdsLCB2ZXJ0ZXhBcnJheSkge1xuICBpZiAoZ2wgaW5zdGFuY2VvZiBXZWJHTDJSZW5kZXJpbmdDb250ZXh0KSB7XG4gICAgZ2wuYmluZFZlcnRleEFycmF5KHZlcnRleEFycmF5KTtcbiAgfVxuICBjb25zdCBleHQgPSBnbC5nZXRFeHRlbnNpb24oT0VTX3ZlcnRleF9hcnJheV9vYmplY3QpO1xuICBpZiAoZXh0KSB7XG4gICAgZXh0LmJpbmRWZXJ0ZXhBcnJheU9FUyh2ZXJ0ZXhBcnJheSk7XG4gIH1cbn1cbiJdfQ==