'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.glArrayFromType = undefined;
exports.glTypeFromArray = glTypeFromArray;
exports.glTypeToArray = glTypeToArray;

var _webglConstants = require('./webgl-constants');

var _webglConstants2 = _interopRequireDefault(_webglConstants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TYPED ARRAYS

function glTypeFromArray(arrayOrType) {
  // If typed array, look up type name
  var type = ArrayBuffer.isView(arrayOrType) ? arrayOrType.constructor : arrayOrType;

  switch (type) {
    case Float32Array:
      return _webglConstants2.default.FLOAT;
    case Uint16Array:
      return _webglConstants2.default.UNSIGNED_SHORT;
    case Uint32Array:
      return _webglConstants2.default.UNSIGNED_INT;
    case Uint8Array:
      return _webglConstants2.default.UNSIGNED_BYTE;
    case Uint8ClampedArray:
      return _webglConstants2.default.UNSIGNED_BYTE;
    case Int8Array:
      return _webglConstants2.default.BYTE;
    case Int16Array:
      return _webglConstants2.default.SHORT;
    case Int32Array:
      return _webglConstants2.default.INT;
    default:
      throw new Error('Failed to deduce type from array/array type');
  }
}

/* eslint-disable complexity */
function glTypeToArray(glType) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$clamped = _ref.clamped,
      clamped = _ref$clamped === undefined ? true : _ref$clamped;

  // Sorted in some order of likelihood to reduce amount of comparisons
  switch (glType) {
    case _webglConstants2.default.FLOAT:
      return Float32Array;
    case _webglConstants2.default.UNSIGNED_SHORT:
    case _webglConstants2.default.UNSIGNED_SHORT_5_6_5:
    case _webglConstants2.default.UNSIGNED_SHORT_4_4_4_4:
    case _webglConstants2.default.UNSIGNED_SHORT_5_5_5_1:
      return Uint16Array;
    case _webglConstants2.default.UNSIGNED_INT:
      return Uint32Array;
    case _webglConstants2.default.UNSIGNED_BYTE:
      return clamped ? Uint8ClampedArray : Uint8Array;
    case _webglConstants2.default.BYTE:
      return Int8Array;
    case _webglConstants2.default.SHORT:
      return Int16Array;
    case _webglConstants2.default.INT:
      return Int32Array;
    default:
      throw new Error('Failed to deduce type from array');
  }
}
/* eslint-enable complexity */

// Deprecated
exports.glArrayFromType = glTypeToArray;
//# sourceMappingURL=data:application/json;base64,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