'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GL = undefined;
exports.glGet = glGet;
exports.glKey = glKey;

var _glConstants = require('gl-constants');

var _glConstants2 = _interopRequireDefault(_glConstants);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// WEBGL BUILT-IN TYPES
exports.GL = _glConstants2.default;
exports.default = _glConstants2.default;

// Resolve a WebGL enumeration name (returns itself if already a number)

function glGet(name) {
  // assertWebGLContext(gl);
  var value = name;
  if (typeof name === 'string') {
    value = _glConstants2.default[name];
    (0, _assert2.default)(value !== undefined, 'Accessing GL.' + name);
  }
  return value;
}

function glKey(value) {
  for (var key in _glConstants2.default) {
    if (_glConstants2.default[key] === value) {
      return 'GL.' + key;
    }
  }
  return String(value);
}

// Extract constants from WebGL prototype
// function getWebGLConstants() {
//   const constants = {};
//   const WebGLContext =
//     glob.WebGL2RenderingContext || WebGLRenderingContext;
//   for (const key in WebGLContext.prototype) {
//     if (typeof WebGLContext[key] !== 'function') {
//       constants[key] = WebGLContext[key];
//     }
//   }
//   Object.freeze(constants);
//   return constants;
// }

// const GL = getWebGLConstants();
//# sourceMappingURL=data:application/json;base64,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