'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebGL2RenderingContext = exports.WebGLShaderPrecisionFormat = exports.WebGLActiveInfo = exports.WebGLUniformLocation = exports.WebGLTexture = exports.WebGLRenderbuffer = exports.WebGLFramebuffer = exports.WebGLBuffer = exports.WebGLShader = exports.WebGLProgram = exports.WebGLRenderingContext = exports.Image = exports.webGLTypesAvailable = undefined;

var _init = require('../init');

var _init2 = _interopRequireDefault(_init);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } // WEBGL BUILT-IN TYPES
// 1) Exports all WebGL constants as {GL}
// 2) Enables app to "import" WebGL types
//    - Importing these types makes them known to eslint etc.
//    - Provides dummy types for WebGL2 when not available to streamline
//      library code.
//    - Exports types from headless gl when running under Node.js

var DummyType = function DummyType() {
  _classCallCheck(this, DummyType);
};

var _ref = _init2.default.globals.headlessTypes || _init.global,
    _ref$WebGLRenderingCo = _ref.WebGLRenderingContext,
    WebGLRenderingContext = _ref$WebGLRenderingCo === undefined ? DummyType : _ref$WebGLRenderingCo,
    _ref$WebGLProgram = _ref.WebGLProgram,
    WebGLProgram = _ref$WebGLProgram === undefined ? DummyType : _ref$WebGLProgram,
    _ref$WebGLShader = _ref.WebGLShader,
    WebGLShader = _ref$WebGLShader === undefined ? DummyType : _ref$WebGLShader,
    _ref$WebGLBuffer = _ref.WebGLBuffer,
    WebGLBuffer = _ref$WebGLBuffer === undefined ? DummyType : _ref$WebGLBuffer,
    _ref$WebGLFramebuffer = _ref.WebGLFramebuffer,
    WebGLFramebuffer = _ref$WebGLFramebuffer === undefined ? DummyType : _ref$WebGLFramebuffer,
    _ref$WebGLRenderbuffe = _ref.WebGLRenderbuffer,
    WebGLRenderbuffer = _ref$WebGLRenderbuffe === undefined ? DummyType : _ref$WebGLRenderbuffe,
    _ref$WebGLTexture = _ref.WebGLTexture,
    WebGLTexture = _ref$WebGLTexture === undefined ? DummyType : _ref$WebGLTexture,
    _ref$WebGLUniformLoca = _ref.WebGLUniformLocation,
    WebGLUniformLocation = _ref$WebGLUniformLoca === undefined ? DummyType : _ref$WebGLUniformLoca,
    _ref$WebGLActiveInfo = _ref.WebGLActiveInfo,
    WebGLActiveInfo = _ref$WebGLActiveInfo === undefined ? DummyType : _ref$WebGLActiveInfo,
    _ref$WebGLShaderPreci = _ref.WebGLShaderPrecisionFormat,
    WebGLShaderPrecisionFormat = _ref$WebGLShaderPreci === undefined ? DummyType : _ref$WebGLShaderPreci;

var webGLTypesAvailable = exports.webGLTypesAvailable = WebGLRenderingContext !== DummyType && WebGLProgram !== DummyType && WebGLShader !== DummyType && WebGLBuffer !== DummyType && WebGLFramebuffer !== DummyType && WebGLRenderbuffer !== DummyType && WebGLTexture !== DummyType && WebGLUniformLocation !== DummyType && WebGLActiveInfo !== DummyType && WebGLShaderPrecisionFormat !== DummyType;

// Ensures that WebGL2RenderingContext is defined in non-WebGL2 environments
// so that apps can test their gl contexts with instanceof
// E.g. if (gl instanceof WebGL2RenderingContext) { }
function getWebGL2RenderingContext() {
  var WebGL2RenderingContextNotSupported = function WebGL2RenderingContextNotSupported() {
    _classCallCheck(this, WebGL2RenderingContextNotSupported);
  };

  return _init.global.WebGL2RenderingContext || WebGL2RenderingContextNotSupported;
}

// Ensure that Image is defined under Node.js
function getImage() {
  var ImageNotSupported = function ImageNotSupported() {
    _classCallCheck(this, ImageNotSupported);
  };

  return _init.global.Image || ImageNotSupported;
}

var WebGL2RenderingContext = getWebGL2RenderingContext();
var Image = getImage();

// Export the standard WebGL types
exports.Image = Image;
exports.WebGLRenderingContext = WebGLRenderingContext;
exports.WebGLProgram = WebGLProgram;
exports.WebGLShader = WebGLShader;
exports.WebGLBuffer = WebGLBuffer;
exports.WebGLFramebuffer = WebGLFramebuffer;
exports.WebGLRenderbuffer = WebGLRenderbuffer;
exports.WebGLTexture = WebGLTexture;
exports.WebGLUniformLocation = WebGLUniformLocation;
exports.WebGLActiveInfo = WebGLActiveInfo;
exports.WebGLShaderPrecisionFormat = WebGLShaderPrecisionFormat;
exports.WebGL2RenderingContext = WebGL2RenderingContext;
//# sourceMappingURL=data:application/json;base64,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