"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.polyfillContext = polyfillContext;

var _polyfillVertexArrayObject = require("./polyfill-vertex-array-object");

var _assert = require("../utils/assert");

var _polyfillTable = require("./polyfill-table");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function polyfillContext(gl) {
  gl.luma = gl.luma || {};
  var luma = gl.luma;

  if (!luma.polyfilled) {
    (0, _polyfillVertexArrayObject.polyfillVertexArrayObject)(gl);
    initializeExtensions(gl);
    installPolyfills(gl, _polyfillTable.WEBGL2_CONTEXT_POLYFILLS);
    installOverrides(gl, {
      target: luma,
      target2: gl
    });
    luma.polyfilled = true;
  }

  return gl;
}

globalThis.polyfillContext = polyfillContext;

function initializeExtensions(gl) {
  gl.luma.extensions = {};
  var EXTENSIONS = gl.getSupportedExtensions() || [];

  var _iterator = _createForOfIteratorHelper(EXTENSIONS),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var extension = _step.value;
      gl.luma[extension] = gl.getExtension(extension);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
}

function installOverrides(gl, _ref) {
  var target = _ref.target,
      target2 = _ref.target2;
  Object.keys(_polyfillTable.WEBGL2_CONTEXT_OVERRIDES).forEach(function (key) {
    if (typeof _polyfillTable.WEBGL2_CONTEXT_OVERRIDES[key] === 'function') {
      var originalFunc = gl[key] ? gl[key].bind(gl) : function () {};

      var polyfill = _polyfillTable.WEBGL2_CONTEXT_OVERRIDES[key].bind(null, gl, originalFunc);

      target[key] = polyfill;
      target2[key] = polyfill;
    }
  });
}

function installPolyfills(gl, polyfills) {
  var _iterator2 = _createForOfIteratorHelper(Object.getOwnPropertyNames(polyfills)),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var extension = _step2.value;

      if (extension !== 'overrides') {
        polyfillExtension(gl, {
          extension: extension,
          target: gl.luma,
          target2: gl
        });
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
}

function polyfillExtension(gl, _ref2) {
  var extension = _ref2.extension,
      target = _ref2.target,
      target2 = _ref2.target2;
  var defaults = _polyfillTable.WEBGL2_CONTEXT_POLYFILLS[extension];
  (0, _assert.assert)(defaults);
  var _defaults$meta = defaults.meta,
      meta = _defaults$meta === void 0 ? {} : _defaults$meta;
  var _meta$suffix = meta.suffix,
      suffix = _meta$suffix === void 0 ? '' : _meta$suffix;
  var ext = gl.getExtension(extension);

  var _loop = function _loop() {
    var key = _Object$keys[_i];
    var extKey = "".concat(key).concat(suffix);
    var polyfill = null;

    if (key === 'meta') {} else if (typeof gl[key] === 'function') {} else if (ext && typeof ext[extKey] === 'function') {
      polyfill = function polyfill() {
        return ext[extKey].apply(ext, arguments);
      };
    } else if (typeof defaults[key] === 'function') {
      polyfill = defaults[key].bind(target);
    }

    if (polyfill) {
      target[key] = polyfill;
      target2[key] = polyfill;
    }
  };

  for (var _i = 0, _Object$keys = Object.keys(defaults); _i < _Object$keys.length; _i++) {
    _loop();
  }
}
//# sourceMappingURL=polyfill-context.js.map