"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParameters = getParameters;
exports.resetParameters = resetParameters;
exports.setParameters = setParameters;
exports.withParameters = withParameters;

var _webglParameterTables = require("./webgl-parameter-tables");

var _trackContextState = require("./track-context-state");

var _assert = require("../utils/assert");

var _webglChecks = require("../utils/webgl-checks");

var _utils = require("../utils/utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function setParameters(gl, values) {
  (0, _assert.assert)((0, _webglChecks.isWebGL)(gl), 'setParameters requires a WebGL context');

  if ((0, _utils.isObjectEmpty)(values)) {
    return;
  }

  var compositeSetters = {};

  for (var key in values) {
    var glConstant = Number(key);
    var setter = _webglParameterTables.GL_PARAMETER_SETTERS[key];

    if (setter) {
      if (typeof setter === 'string') {
        compositeSetters[setter] = true;
      } else {
        setter(gl, values[key], glConstant);
      }
    }
  }

  var cache = gl.state && gl.state.cache;

  if (cache) {
    for (var _key in compositeSetters) {
      var compositeSetter = _webglParameterTables.GL_COMPOSITE_PARAMETER_SETTERS[_key];
      compositeSetter(gl, values, cache);
    }
  }
}

function getParameters(gl, parameters) {
  parameters = parameters || _webglParameterTables.GL_PARAMETER_DEFAULTS;

  if (typeof parameters === 'number') {
    var key = parameters;
    var getter = _webglParameterTables.GL_PARAMETER_GETTERS[key];
    return getter ? getter(gl, key) : gl.getParameter(key);
  }

  var parameterKeys = Array.isArray(parameters) ? parameters : Object.keys(parameters);
  var state = {};

  var _iterator = _createForOfIteratorHelper(parameterKeys),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _key2 = _step.value;
      var _getter = _webglParameterTables.GL_PARAMETER_GETTERS[_key2];
      state[_key2] = _getter ? _getter(gl, Number(_key2)) : gl.getParameter(Number(_key2));
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return state;
}

function resetParameters(gl) {
  setParameters(gl, _webglParameterTables.GL_PARAMETER_DEFAULTS);
}

function withParameters(gl, parameters, func) {
  if ((0, _utils.isObjectEmpty)(parameters)) {
    return func(gl);
  }

  var _parameters$nocatch = parameters.nocatch,
      nocatch = _parameters$nocatch === void 0 ? true : _parameters$nocatch;
  (0, _trackContextState.pushContextState)(gl);
  setParameters(gl, parameters);
  var value;

  if (nocatch) {
    value = func(gl);
    (0, _trackContextState.popContextState)(gl);
  } else {
    try {
      value = func(gl);
    } finally {
      (0, _trackContextState.popContextState)(gl);
    }
  }

  return value;
}
//# sourceMappingURL=unified-parameter-api.js.map