"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cssToDevicePixels = cssToDevicePixels;
exports.cssToDeviceRatio = cssToDeviceRatio;
exports.getDevicePixelRatio = getDevicePixelRatio;

function cssToDeviceRatio(gl) {
  var luma = gl.luma;

  if (gl.canvas && luma) {
    var cachedSize = luma.canvasSizeInfo;
    var clientWidth = 'clientWidth' in cachedSize ? cachedSize.clientWidth : gl.canvas.clientWidth;
    return clientWidth ? gl.drawingBufferWidth / clientWidth : 1;
  }

  return 1;
}

function cssToDevicePixels(gl, cssPixel) {
  var yInvert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  var ratio = cssToDeviceRatio(gl);
  var width = gl.drawingBufferWidth;
  var height = gl.drawingBufferHeight;
  return scalePixels(cssPixel, ratio, width, height, yInvert);
}

function getDevicePixelRatio(useDevicePixels) {
  var windowRatio = typeof window === 'undefined' ? 1 : window.devicePixelRatio || 1;

  if (Number.isFinite(useDevicePixels)) {
    return useDevicePixels <= 0 ? 1 : useDevicePixels;
  }

  return useDevicePixels ? windowRatio : 1;
}

function scalePixels(pixel, ratio, width, height, yInvert) {
  var x = scaleX(pixel[0], ratio, width);
  var y = scaleY(pixel[1], ratio, height, yInvert);
  var t = scaleX(pixel[0] + 1, ratio, width);
  var xHigh = t === width - 1 ? t : t - 1;
  t = scaleY(pixel[1] + 1, ratio, height, yInvert);
  var yHigh;

  if (yInvert) {
    t = t === 0 ? t : t + 1;
    yHigh = y;
    y = t;
  } else {
    yHigh = t === height - 1 ? t : t - 1;
  }

  return {
    x: x,
    y: y,
    width: Math.max(xHigh - x + 1, 1),
    height: Math.max(yHigh - y + 1, 1)
  };
}

function scaleX(x, ratio, width) {
  var r = Math.min(Math.round(x * ratio), width - 1);
  return r;
}

function scaleY(y, ratio, height, yInvert) {
  return yInvert ? Math.max(0, height - 1 - Math.round(y * ratio)) : Math.min(Math.round(y * ratio), height - 1);
}
//# sourceMappingURL=device-pixels.js.map