"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERR_WEBGL2 = exports.ERR_WEBGL = void 0;
exports.assertWebGL2Context = assertWebGL2Context;
exports.assertWebGLContext = assertWebGLContext;
exports.getWebGL2Context = getWebGL2Context;
exports.isWebGL = isWebGL;
exports.isWebGL2 = isWebGL2;

var _assert = require("./assert");

var ERR_CONTEXT = 'Invalid WebGLRenderingContext';
var ERR_WEBGL = ERR_CONTEXT;
exports.ERR_WEBGL = ERR_WEBGL;
var ERR_WEBGL2 = 'Requires WebGL2';
exports.ERR_WEBGL2 = ERR_WEBGL2;

function isWebGL(gl) {
  if (typeof WebGLRenderingContext !== 'undefined' && gl instanceof WebGLRenderingContext) {
    return true;
  }

  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return true;
  }

  return Boolean(gl && Number.isFinite(gl._version));
}

function isWebGL2(gl) {
  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return true;
  }

  return Boolean(gl && gl._version === 2);
}

function getWebGL2Context(gl) {
  return isWebGL2(gl) ? gl : null;
}

function assertWebGLContext(gl) {
  (0, _assert.assert)(isWebGL(gl), ERR_CONTEXT);
  return gl;
}

function assertWebGL2Context(gl) {
  (0, _assert.assert)(isWebGL2(gl), ERR_WEBGL2);
  return gl;
}
//# sourceMappingURL=webgl-checks.js.map