import { GL_PARAMETER_DEFAULTS, GL_PARAMETER_SETTERS, GL_COMPOSITE_PARAMETER_SETTERS, GL_PARAMETER_GETTERS } from './webgl-parameter-tables';
import { pushContextState, popContextState } from './track-context-state';
import { assert } from '../utils/assert';
import { isWebGL } from '../utils/webgl-checks';
import { isObjectEmpty } from '../utils/utils';
export function setParameters(gl, values) {
  assert(isWebGL(gl), 'setParameters requires a WebGL context');

  if (isObjectEmpty(values)) {
    return;
  }

  const compositeSetters = {};

  for (const key in values) {
    const glConstant = Number(key);
    const setter = GL_PARAMETER_SETTERS[key];

    if (setter) {
      if (typeof setter === 'string') {
        compositeSetters[setter] = true;
      } else {
        setter(gl, values[key], glConstant);
      }
    }
  }

  const cache = gl.state && gl.state.cache;

  if (cache) {
    for (const key in compositeSetters) {
      const compositeSetter = GL_COMPOSITE_PARAMETER_SETTERS[key];
      compositeSetter(gl, values, cache);
    }
  }
}
export function getParameters(gl, parameters) {
  parameters = parameters || GL_PARAMETER_DEFAULTS;

  if (typeof parameters === 'number') {
    const key = parameters;
    const getter = GL_PARAMETER_GETTERS[key];
    return getter ? getter(gl, key) : gl.getParameter(key);
  }

  const parameterKeys = Array.isArray(parameters) ? parameters : Object.keys(parameters);
  const state = {};

  for (const key of parameterKeys) {
    const getter = GL_PARAMETER_GETTERS[key];
    state[key] = getter ? getter(gl, Number(key)) : gl.getParameter(Number(key));
  }

  return state;
}
export function resetParameters(gl) {
  setParameters(gl, GL_PARAMETER_DEFAULTS);
}
export function withParameters(gl, parameters, func) {
  if (isObjectEmpty(parameters)) {
    return func(gl);
  }

  const {
    nocatch = true
  } = parameters;
  pushContextState(gl);
  setParameters(gl, parameters);
  let value;

  if (nocatch) {
    value = func(gl);
    popContextState(gl);
  } else {
    try {
      value = func(gl);
    } finally {
      popContextState(gl);
    }
  }

  return value;
}
//# sourceMappingURL=unified-parameter-api.js.map