"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  assembleShaders: true,
  combineInjects: true,
  normalizeShaderModule: true,
  getQualifierDetails: true,
  getPassthroughFS: true,
  typeToChannelSuffix: true,
  typeToChannelCount: true,
  convertToVec4: true
};
Object.defineProperty(exports, "assembleShaders", {
  enumerable: true,
  get: function get() {
    return _assembleShaders.assembleShaders;
  }
});
Object.defineProperty(exports, "combineInjects", {
  enumerable: true,
  get: function get() {
    return _injectShader.combineInjects;
  }
});
Object.defineProperty(exports, "convertToVec4", {
  enumerable: true,
  get: function get() {
    return _shaderUtils.convertToVec4;
  }
});
Object.defineProperty(exports, "getPassthroughFS", {
  enumerable: true,
  get: function get() {
    return _shaderUtils.getPassthroughFS;
  }
});
Object.defineProperty(exports, "getQualifierDetails", {
  enumerable: true,
  get: function get() {
    return _shaderUtils.getQualifierDetails;
  }
});
Object.defineProperty(exports, "normalizeShaderModule", {
  enumerable: true,
  get: function get() {
    return _shaderModule.normalizeShaderModule;
  }
});
Object.defineProperty(exports, "typeToChannelCount", {
  enumerable: true,
  get: function get() {
    return _shaderUtils.typeToChannelCount;
  }
});
Object.defineProperty(exports, "typeToChannelSuffix", {
  enumerable: true,
  get: function get() {
    return _shaderUtils.typeToChannelSuffix;
  }
});

var _assembleShaders = require("./lib/assemble-shaders");

var _injectShader = require("./lib/inject-shader");

var _shaderModule = require("./lib/shader-module");

var _shaderUtils = require("./utils/shader-utils");

var _modules = require("./modules");

Object.keys(_modules).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _modules[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _modules[key];
    }
  });
});
//# sourceMappingURL=index.js.map