"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DECLARATION_INJECT_MARKER = void 0;
exports.combineInjects = combineInjects;
exports.default = injectShader;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _moduleInjectors = require("../modules/module-injectors");

var _constants = require("./constants");

var _utils = require("../utils");

var _MODULE_INJECTORS;

var MODULE_INJECTORS = (_MODULE_INJECTORS = {}, (0, _defineProperty2.default)(_MODULE_INJECTORS, _constants.VERTEX_SHADER, _moduleInjectors.MODULE_INJECTORS_VS), (0, _defineProperty2.default)(_MODULE_INJECTORS, _constants.FRAGMENT_SHADER, _moduleInjectors.MODULE_INJECTORS_FS), _MODULE_INJECTORS);
var DECLARATION_INJECT_MARKER = '__LUMA_INJECT_DECLARATIONS__';
exports.DECLARATION_INJECT_MARKER = DECLARATION_INJECT_MARKER;
var REGEX_START_OF_MAIN = /void\s+main\s*\([^)]*\)\s*\{\n?/;
var REGEX_END_OF_MAIN = /}\n?[^{}]*$/;
var fragments = [];

function injectShader(source, type, inject) {
  var injectStandardStubs = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  var isVertex = type === _constants.VERTEX_SHADER;

  var _loop = function _loop(key) {
    var fragmentData = inject[key];
    fragmentData.sort(function (a, b) {
      return a.order - b.order;
    });
    fragments.length = fragmentData.length;

    for (var i = 0, len = fragmentData.length; i < len; ++i) {
      fragments[i] = fragmentData[i].injection;
    }

    var fragmentString = "".concat(fragments.join('\n'), "\n");

    switch (key) {
      case 'vs:#decl':
        if (isVertex) {
          source = source.replace(DECLARATION_INJECT_MARKER, fragmentString);
        }

        break;

      case 'vs:#main-start':
        if (isVertex) {
          source = source.replace(REGEX_START_OF_MAIN, function (match) {
            return match + fragmentString;
          });
        }

        break;

      case 'vs:#main-end':
        if (isVertex) {
          source = source.replace(REGEX_END_OF_MAIN, function (match) {
            return fragmentString + match;
          });
        }

        break;

      case 'fs:#decl':
        if (!isVertex) {
          source = source.replace(DECLARATION_INJECT_MARKER, fragmentString);
        }

        break;

      case 'fs:#main-start':
        if (!isVertex) {
          source = source.replace(REGEX_START_OF_MAIN, function (match) {
            return match + fragmentString;
          });
        }

        break;

      case 'fs:#main-end':
        if (!isVertex) {
          source = source.replace(REGEX_END_OF_MAIN, function (match) {
            return fragmentString + match;
          });
        }

        break;

      default:
        source = source.replace(key, function (match) {
          return match + fragmentString;
        });
    }
  };

  for (var key in inject) {
    _loop(key);
  }

  source = source.replace(DECLARATION_INJECT_MARKER, '');

  if (injectStandardStubs) {
    source = source.replace(/\}\s*$/, function (match) {
      return match + MODULE_INJECTORS[type];
    });
  }

  return source;
}

function combineInjects(injects) {
  var result = {};
  (0, _utils.assert)(Array.isArray(injects) && injects.length > 1);
  injects.forEach(function (inject) {
    for (var key in inject) {
      result[key] = result[key] ? "".concat(result[key], "\n").concat(inject[key]) : inject[key];
    }
  });
  return result;
}
//# sourceMappingURL=inject-shader.js.map