"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_EXPORTS = void 0;
exports.resolveModules = resolveModules;

var _shaderModule = _interopRequireDefault(require("./shader-module"));

var _utils = require("../utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function resolveModules(modules) {
  return getShaderDependencies(instantiateModules(modules));
}

function getShaderDependencies(modules) {
  var moduleMap = {};
  var moduleDepth = {};
  getDependencyGraph({
    modules: modules,
    level: 0,
    moduleMap: moduleMap,
    moduleDepth: moduleDepth
  });
  return Object.keys(moduleDepth).sort(function (a, b) {
    return moduleDepth[b] - moduleDepth[a];
  }).map(function (name) {
    return moduleMap[name];
  });
}

function getDependencyGraph(_ref) {
  var modules = _ref.modules,
      level = _ref.level,
      moduleMap = _ref.moduleMap,
      moduleDepth = _ref.moduleDepth;

  if (level >= 5) {
    throw new Error('Possible loop in shader dependency graph');
  }

  var _iterator = _createForOfIteratorHelper(modules),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var module = _step.value;
      moduleMap[module.name] = module;

      if (moduleDepth[module.name] === undefined || moduleDepth[module.name] < level) {
        moduleDepth[module.name] = level;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var _iterator2 = _createForOfIteratorHelper(modules),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var _module = _step2.value;

      if (_module.dependencies) {
        getDependencyGraph({
          modules: _module.dependencies,
          level: level + 1,
          moduleMap: moduleMap,
          moduleDepth: moduleDepth
        });
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
}

function instantiateModules(modules, seen) {
  return modules.map(function (module) {
    if (module instanceof _shaderModule.default) {
      return module;
    }

    (0, _utils.assert)(typeof module !== 'string', "Shader module use by name is deprecated. Import shader module '".concat(module, "' and use it directly."));
    (0, _utils.assert)(module.name, 'shader module has no name');
    module = new _shaderModule.default(module);
    module.dependencies = instantiateModules(module.dependencies);
    return module;
  });
}

var TEST_EXPORTS = {
  getShaderDependencies: getShaderDependencies,
  getDependencyGraph: getDependencyGraph
};
exports.TEST_EXPORTS = TEST_EXPORTS;
//# sourceMappingURL=resolve-modules.js.map