"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.normalizeShaderModule = normalizeShaderModule;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _utils = require("../utils");

var _propTypes = require("./filters/prop-types");

var VERTEX_SHADER = 'vs';
var FRAGMENT_SHADER = 'fs';

var ShaderModule = function () {
  function ShaderModule(_ref) {
    var name = _ref.name,
        vs = _ref.vs,
        fs = _ref.fs,
        _ref$dependencies = _ref.dependencies,
        dependencies = _ref$dependencies === void 0 ? [] : _ref$dependencies,
        uniforms = _ref.uniforms,
        getUniforms = _ref.getUniforms,
        _ref$deprecations = _ref.deprecations,
        deprecations = _ref$deprecations === void 0 ? [] : _ref$deprecations,
        _ref$defines = _ref.defines,
        defines = _ref$defines === void 0 ? {} : _ref$defines,
        _ref$inject = _ref.inject,
        inject = _ref$inject === void 0 ? {} : _ref$inject,
        vertexShader = _ref.vertexShader,
        fragmentShader = _ref.fragmentShader;
    (0, _classCallCheck2.default)(this, ShaderModule);
    (0, _utils.assert)(typeof name === 'string');
    this.name = name;
    this.vs = vs || vertexShader;
    this.fs = fs || fragmentShader;
    this.getModuleUniforms = getUniforms;
    this.dependencies = dependencies;
    this.deprecations = this._parseDeprecationDefinitions(deprecations);
    this.defines = defines;
    this.injections = normalizeInjections(inject);

    if (uniforms) {
      this.uniforms = (0, _propTypes.parsePropTypes)(uniforms);
    }
  }

  (0, _createClass2.default)(ShaderModule, [{
    key: "getModuleSource",
    value: function getModuleSource(type) {
      var moduleSource;

      switch (type) {
        case VERTEX_SHADER:
          moduleSource = this.vs || '';
          break;

        case FRAGMENT_SHADER:
          moduleSource = this.fs || '';
          break;

        default:
          (0, _utils.assert)(false);
      }

      return "#define MODULE_".concat(this.name.toUpperCase().replace(/[^0-9a-z]/gi, '_'), "\n").concat(moduleSource, "// END MODULE_").concat(this.name, "\n\n");
    }
  }, {
    key: "getUniforms",
    value: function getUniforms(opts, uniforms) {
      if (this.getModuleUniforms) {
        return this.getModuleUniforms(opts, uniforms);
      }

      if (this.uniforms) {
        return this._defaultGetUniforms(opts);
      }

      return {};
    }
  }, {
    key: "getDefines",
    value: function getDefines() {
      return this.defines;
    }
  }, {
    key: "checkDeprecations",
    value: function checkDeprecations(shaderSource, log) {
      this.deprecations.forEach(function (def) {
        if (def.regex.test(shaderSource)) {
          if (def.deprecated) {
            log.deprecated(def.old, def.new)();
          } else {
            log.removed(def.old, def.new)();
          }
        }
      });
    }
  }, {
    key: "_parseDeprecationDefinitions",
    value: function _parseDeprecationDefinitions(deprecations) {
      deprecations.forEach(function (def) {
        switch (def.type) {
          case 'function':
            def.regex = new RegExp("\\b".concat(def.old, "\\("));
            break;

          default:
            def.regex = new RegExp("".concat(def.type, " ").concat(def.old, ";"));
        }
      });
      return deprecations;
    }
  }, {
    key: "_defaultGetUniforms",
    value: function _defaultGetUniforms() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var uniforms = {};
      var propTypes = this.uniforms;

      for (var key in propTypes) {
        var propDef = propTypes[key];

        if (key in opts && !propDef.private) {
          if (propDef.validate) {
            (0, _utils.assert)(propDef.validate(opts[key], propDef), "".concat(this.name, ": invalid ").concat(key));
          }

          uniforms[key] = opts[key];
        } else {
          uniforms[key] = propDef.value;
        }
      }

      return uniforms;
    }
  }]);
  return ShaderModule;
}();

exports.default = ShaderModule;

function normalizeShaderModule(module) {
  if (!module.normalized) {
    module.normalized = true;

    if (module.uniforms && !module.getUniforms) {
      var shaderModule = new ShaderModule(module);
      module.getUniforms = shaderModule.getUniforms.bind(shaderModule);
    }
  }

  return module;
}

function normalizeInjections(injections) {
  var result = {
    vs: {},
    fs: {}
  };

  for (var hook in injections) {
    var injection = injections[hook];
    var stage = hook.slice(0, 2);

    if (typeof injection === 'string') {
      injection = {
        order: 0,
        injection: injection
      };
    }

    result[stage][hook] = injection;
  }

  return result;
}
//# sourceMappingURL=shader-module.js.map