"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lights = void 0;

var _lights = _interopRequireDefault(require("./lights.glsl"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var INITIAL_MODULE_OPTIONS = {
  lightSources: {}
};

function convertColor() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? [0, 0, 0] : _ref$color,
      _ref$intensity = _ref.intensity,
      intensity = _ref$intensity === void 0 ? 1.0 : _ref$intensity;

  return color.map(function (component) {
    return component * intensity / 255.0;
  });
}

function getLightSourceUniforms(_ref2) {
  var ambientLight = _ref2.ambientLight,
      _ref2$pointLights = _ref2.pointLights,
      pointLights = _ref2$pointLights === void 0 ? [] : _ref2$pointLights,
      _ref2$directionalLigh = _ref2.directionalLights,
      directionalLights = _ref2$directionalLigh === void 0 ? [] : _ref2$directionalLigh;
  var lightSourceUniforms = {};

  if (ambientLight) {
    lightSourceUniforms['lighting_uAmbientLight.color'] = convertColor(ambientLight);
  } else {
    lightSourceUniforms['lighting_uAmbientLight.color'] = [0, 0, 0];
  }

  pointLights.forEach(function (pointLight, index) {
    lightSourceUniforms["lighting_uPointLight[".concat(index, "].color")] = convertColor(pointLight);
    lightSourceUniforms["lighting_uPointLight[".concat(index, "].position")] = pointLight.position;
    lightSourceUniforms["lighting_uPointLight[".concat(index, "].attenuation")] = pointLight.attenuation || [1, 0, 0];
  });
  lightSourceUniforms.lighting_uPointLightCount = pointLights.length;
  directionalLights.forEach(function (directionalLight, index) {
    lightSourceUniforms["lighting_uDirectionalLight[".concat(index, "].color")] = convertColor(directionalLight);
    lightSourceUniforms["lighting_uDirectionalLight[".concat(index, "].direction")] = directionalLight.direction;
  });
  lightSourceUniforms.lighting_uDirectionalLightCount = directionalLights.length;
  return lightSourceUniforms;
}

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL_MODULE_OPTIONS;

  if ('lightSources' in opts) {
    var _ref3 = opts.lightSources || {},
        ambientLight = _ref3.ambientLight,
        pointLights = _ref3.pointLights,
        directionalLights = _ref3.directionalLights;

    var hasLights = ambientLight || pointLights && pointLights.length > 0 || directionalLights && directionalLights.length > 0;

    if (!hasLights) {
      return {
        lighting_uEnabled: false
      };
    }

    return Object.assign({}, getLightSourceUniforms({
      ambientLight: ambientLight,
      pointLights: pointLights,
      directionalLights: directionalLights
    }), {
      lighting_uEnabled: true
    });
  }

  if ('lights' in opts) {
    var lightSources = {
      pointLights: [],
      directionalLights: []
    };

    var _iterator = _createForOfIteratorHelper(opts.lights || []),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var light = _step.value;

        switch (light.type) {
          case 'ambient':
            lightSources.ambientLight = light;
            break;

          case 'directional':
            lightSources.directionalLights.push(light);
            break;

          case 'point':
            lightSources.pointLights.push(light);
            break;

          default:
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return getUniforms({
      lightSources: lightSources
    });
  }

  return {};
}

var lights = {
  name: 'lights',
  vs: _lights.default,
  fs: _lights.default,
  getUniforms: getUniforms,
  defines: {
    MAX_LIGHTS: 3
  }
};
exports.lights = lights;
//# sourceMappingURL=lights.js.map