"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FEATURES = void 0;
exports.canCompileGLGSExtension = canCompileGLGSExtension;
exports.getContextInfo = getContextInfo;
exports.hasFeatures = hasFeatures;

var _isOldIe = _interopRequireDefault(require("./is-old-ie"));

var _assert = _interopRequireDefault(require("./assert"));

var GL_VENDOR = 0x1f00;
var GL_RENDERER = 0x1f01;
var GL_VERSION = 0x1f02;
var GL_SHADING_LANGUAGE_VERSION = 0x8b8c;
var WEBGL_FEATURES = {
  GLSL_FRAG_DATA: ['WEBGL_draw_buffers', true],
  GLSL_FRAG_DEPTH: ['EXT_frag_depth', true],
  GLSL_DERIVATIVES: ['OES_standard_derivatives', true],
  GLSL_TEXTURE_LOD: ['EXT_shader_texture_lod', true]
};
var FEATURES = {};
exports.FEATURES = FEATURES;
Object.keys(WEBGL_FEATURES).forEach(function (key) {
  FEATURES[key] = key;
});

function isWebGL2(gl) {
  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return true;
  }

  return Boolean(gl && gl._version === 2);
}

function getContextInfo(gl) {
  var info = gl.getExtension('WEBGL_debug_renderer_info');
  var vendor = gl.getParameter(info && info.UNMASKED_VENDOR_WEBGL || GL_VENDOR);
  var renderer = gl.getParameter(info && info.UNMASKED_RENDERER_WEBGL || GL_RENDERER);
  var gpuVendor = identifyGPUVendor(vendor, renderer);
  var gpuInfo = {
    gpuVendor: gpuVendor,
    vendor: vendor,
    renderer: renderer,
    version: gl.getParameter(GL_VERSION),
    shadingLanguageVersion: gl.getParameter(GL_SHADING_LANGUAGE_VERSION)
  };
  return gpuInfo;
}

function identifyGPUVendor(vendor, renderer) {
  if (vendor.match(/NVIDIA/i) || renderer.match(/NVIDIA/i)) {
    return 'NVIDIA';
  }

  if (vendor.match(/INTEL/i) || renderer.match(/INTEL/i)) {
    return 'INTEL';
  }

  if (vendor.match(/AMD/i) || renderer.match(/AMD/i) || vendor.match(/ATI/i) || renderer.match(/ATI/i)) {
    return 'AMD';
  }

  return 'UNKNOWN GPU';
}

var compiledGlslExtensions = {};

function canCompileGLGSExtension(gl, cap) {
  var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var feature = WEBGL_FEATURES[cap];
  (0, _assert.default)(feature, cap);

  if (!(0, _isOldIe.default)(opts)) {
    return true;
  }

  if (cap in compiledGlslExtensions) {
    return compiledGlslExtensions[cap];
  }

  var extensionName = feature[0];
  var behavior = opts.behavior || 'enable';
  var source = "#extension GL_".concat(extensionName, " : ").concat(behavior, "\nvoid main(void) {}");
  var shader = gl.createShader(35633);
  gl.shaderSource(shader, source);
  gl.compileShader(shader);
  var canCompile = gl.getShaderParameter(shader, 35713);
  gl.deleteShader(shader);
  compiledGlslExtensions[cap] = canCompile;
  return canCompile;
}

function getFeature(gl, cap) {
  var feature = WEBGL_FEATURES[cap];
  (0, _assert.default)(feature, cap);
  var extensionName = isWebGL2(gl) ? feature[1] || feature[0] : feature[0];
  var value = typeof extensionName === 'string' ? Boolean(gl.getExtension(extensionName)) : extensionName;
  (0, _assert.default)(value === false || value === true);
  return value;
}

function hasFeatures(gl, features) {
  features = Array.isArray(features) ? features : [features];
  return features.every(function (feature) {
    return getFeature(gl, feature);
  });
}
//# sourceMappingURL=webgl-info.js.map