import { getContextInfo, hasFeatures, canCompileGLGSExtension, FEATURES } from '../utils/webgl-info';
export function getPlatformShaderDefines(gl) {
  const debugInfo = getContextInfo(gl);

  switch (debugInfo.gpuVendor.toLowerCase()) {
    case 'nvidia':
      return "#define NVIDIA_GPU\n// Nvidia optimizes away the calculation necessary for emulated fp64\n#define LUMA_FP64_CODE_ELIMINATION_WORKAROUND 1\n";

    case 'intel':
      return "#define INTEL_GPU\n// Intel optimizes away the calculation necessary for emulated fp64\n#define LUMA_FP64_CODE_ELIMINATION_WORKAROUND 1\n// Intel's built-in 'tan' function doesn't have acceptable precision\n#define LUMA_FP32_TAN_PRECISION_WORKAROUND 1\n// Intel GPU doesn't have full 32 bits precision in same cases, causes overflow\n#define LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND 1\n";

    case 'amd':
      return "#define AMD_GPU\n";

    default:
      return "#define DEFAULT_GPU\n// Prevent driver from optimizing away the calculation necessary for emulated fp64\n#define LUMA_FP64_CODE_ELIMINATION_WORKAROUND 1\n// Intel's built-in 'tan' function doesn't have acceptable precision\n#define LUMA_FP32_TAN_PRECISION_WORKAROUND 1\n// Intel GPU doesn't have full 32 bits precision in same cases, causes overflow\n#define LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND 1\n";
  }
}
export function getVersionDefines(gl, glslVersion, isFragment) {
  let versionDefines = "#if (__VERSION__ > 120)\n\n# define FEATURE_GLSL_DERIVATIVES\n# define FEATURE_GLSL_DRAW_BUFFERS\n# define FEATURE_GLSL_FRAG_DEPTH\n# define FEATURE_GLSL_TEXTURE_LOD\n\n// DEPRECATED FLAGS, remove in v9\n# define FRAG_DEPTH\n# define DERIVATIVES\n# define DRAW_BUFFERS\n# define TEXTURE_LOD\n\n#endif // __VERSION\n";

  if (hasFeatures(gl, FEATURES.GLSL_FRAG_DEPTH)) {
    versionDefines += "\n// FRAG_DEPTH => gl_FragDepth is available\n#ifdef GL_EXT_frag_depth\n#extension GL_EXT_frag_depth : enable\n# define FEATURE_GLSL_FRAG_DEPTH\n# define FRAG_DEPTH\n# define gl_FragDepth gl_FragDepthEXT\n#endif\n";
  }

  if (hasFeatures(gl, FEATURES.GLSL_DERIVATIVES) && canCompileGLGSExtension(gl, FEATURES.GLSL_DERIVATIVES)) {
    versionDefines += "\n// DERIVATIVES => dxdF, dxdY and fwidth are available\n#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n# define FEATURE_GLSL_DERIVATIVES\n# define DERIVATIVES\n#endif\n";
  }

  if (hasFeatures(gl, FEATURES.GLSL_FRAG_DATA) && canCompileGLGSExtension(gl, FEATURES.GLSL_FRAG_DATA, {
    behavior: 'require'
  })) {
    versionDefines += "\n// DRAW_BUFFERS => gl_FragData[] is available\n#ifdef GL_EXT_draw_buffers\n#extension GL_EXT_draw_buffers : require\n#define FEATURE_GLSL_DRAW_BUFFERS\n#define DRAW_BUFFERS\n#endif\n";
  }

  if (hasFeatures(gl, FEATURES.GLSL_TEXTURE_LOD)) {
    versionDefines += "// TEXTURE_LOD => texture2DLod etc are available\n#ifdef GL_EXT_shader_texture_lod\n#extension GL_EXT_shader_texture_lod : enable\n\n# define FEATURE_GLSL_TEXTURE_LOD\n# define TEXTURE_LOD\n\n#endif\n";
  }

  return versionDefines;
}
//# sourceMappingURL=platform-defines.js.map