const fs = "uniform vec2 screenXY;\nuniform float radiusPixels;\nuniform float zoom;\nuniform float borderWidthPixels;\nuniform vec4 borderColor;\n\nvec4 magnify_sampleColor(sampler2D texture, vec2 texSize, vec2 texCoord) {\n  vec2 pos = vec2(screenXY.x, 1.0 - screenXY.y);\n  float dist = distance(texCoord * texSize, pos * texSize);\n  if (dist < radiusPixels) {\n    return texture2D(texture, (texCoord - pos) / zoom + pos);\n  }\n\n  if (dist <= radiusPixels + borderWidthPixels) {\n    return borderColor;\n  }\n  return texture2D(texture, texCoord);\n}\n";
const uniforms = {
  screenXY: [0, 0],
  radiusPixels: 200,
  zoom: 2.0,
  borderWidthPixels: 0.0,
  borderColor: [255, 255, 255, 255]
};
export const magnify = {
  name: 'magnify',
  uniforms,
  fs,
  passes: [{
    sampler: true
  }]
};
//# sourceMappingURL=magnify.js.map