"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FRAMEBUFFER_ATTACHMENT_PARAMETERS = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _gltools = require("@luma.gl/gltools");

var _resource = _interopRequireDefault(require("./resource"));

var _texture2d = _interopRequireDefault(require("./texture-2d"));

var _renderbuffer = _interopRequireDefault(require("./renderbuffer"));

var _clear2 = require("./clear");

var _copyAndBlit = require("./copy-and-blit.js");

var _features = require("../features");

var _constantsToKeys = require("../webgl-utils/constants-to-keys");

var _assert = require("../utils/assert");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ERR_MULTIPLE_RENDERTARGETS = 'Multiple render targets not supported';

var Framebuffer = function (_Resource, _Symbol$toStringTag) {
  (0, _inherits2.default)(Framebuffer, _Resource);

  var _super = _createSuper(Framebuffer);

  function Framebuffer(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Framebuffer);
    _this = _super.call(this, gl, opts);
    _this.width = null;
    _this.height = null;
    _this.attachments = {};
    _this.readBuffer = 36064;
    _this.drawBuffers = [36064];
    _this.ownResources = [];

    _this.initialize(opts);

    Object.seal((0, _assertThisInitialized2.default)(_this));
    return _this;
  }

  (0, _createClass2.default)(Framebuffer, [{
    key: _Symbol$toStringTag,
    get: function get() {
      return 'Framebuffer';
    }
  }, {
    key: "MAX_COLOR_ATTACHMENTS",
    get: function get() {
      var gl2 = (0, _gltools.assertWebGL2Context)(this.gl);
      return gl2.getParameter(gl2.MAX_COLOR_ATTACHMENTS);
    }
  }, {
    key: "MAX_DRAW_BUFFERS",
    get: function get() {
      var gl2 = (0, _gltools.assertWebGL2Context)(this.gl);
      return gl2.getParameter(gl2.MAX_DRAW_BUFFERS);
    }
  }, {
    key: "color",
    get: function get() {
      return this.attachments[36064] || null;
    }
  }, {
    key: "texture",
    get: function get() {
      return this.attachments[36064] || null;
    }
  }, {
    key: "depth",
    get: function get() {
      return this.attachments[36096] || this.attachments[33306] || null;
    }
  }, {
    key: "stencil",
    get: function get() {
      return this.attachments[36128] || this.attachments[33306] || null;
    }
  }, {
    key: "initialize",
    value: function initialize(_ref) {
      var _ref$width = _ref.width,
          width = _ref$width === void 0 ? 1 : _ref$width,
          _ref$height = _ref.height,
          height = _ref$height === void 0 ? 1 : _ref$height,
          _ref$attachments = _ref.attachments,
          attachments = _ref$attachments === void 0 ? null : _ref$attachments,
          _ref$color = _ref.color,
          color = _ref$color === void 0 ? true : _ref$color,
          _ref$depth = _ref.depth,
          depth = _ref$depth === void 0 ? true : _ref$depth,
          _ref$stencil = _ref.stencil,
          stencil = _ref$stencil === void 0 ? false : _ref$stencil,
          _ref$check = _ref.check,
          check = _ref$check === void 0 ? true : _ref$check,
          _ref$readBuffer = _ref.readBuffer,
          readBuffer = _ref$readBuffer === void 0 ? undefined : _ref$readBuffer,
          _ref$drawBuffers = _ref.drawBuffers,
          drawBuffers = _ref$drawBuffers === void 0 ? undefined : _ref$drawBuffers;
      (0, _assert.assert)(width >= 0 && height >= 0, 'Width and height need to be integers');
      this.width = width;
      this.height = height;

      if (attachments) {
        for (var attachment in attachments) {
          var target = attachments[attachment];
          var object = Array.isArray(target) ? target[0] : target;
          object.resize({
            width: width,
            height: height
          });
        }
      } else {
        attachments = this._createDefaultAttachments(color, depth, stencil, width, height);
      }

      this.update({
        clearAttachments: true,
        attachments: attachments,
        readBuffer: readBuffer,
        drawBuffers: drawBuffers
      });

      if (attachments && check) {
        this.checkStatus();
      }
    }
  }, {
    key: "delete",
    value: function _delete() {
      var _iterator = _createForOfIteratorHelper(this.ownResources),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var resource = _step.value;
          resource.delete();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      (0, _get2.default)((0, _getPrototypeOf2.default)(Framebuffer.prototype), "delete", this).call(this);
      return this;
    }
  }, {
    key: "update",
    value: function update(_ref2) {
      var _ref2$attachments = _ref2.attachments,
          attachments = _ref2$attachments === void 0 ? {} : _ref2$attachments,
          readBuffer = _ref2.readBuffer,
          drawBuffers = _ref2.drawBuffers,
          _ref2$clearAttachment = _ref2.clearAttachments,
          clearAttachments = _ref2$clearAttachment === void 0 ? false : _ref2$clearAttachment,
          _ref2$resizeAttachmen = _ref2.resizeAttachments,
          resizeAttachments = _ref2$resizeAttachmen === void 0 ? true : _ref2$resizeAttachmen;
      this.attach(attachments, {
        clearAttachments: clearAttachments,
        resizeAttachments: resizeAttachments
      });
      var gl = this.gl;
      var prevHandle = gl.bindFramebuffer(36160, this.handle);

      if (readBuffer) {
        this._setReadBuffer(readBuffer);
      }

      if (drawBuffers) {
        this._setDrawBuffers(drawBuffers);
      }

      gl.bindFramebuffer(36160, prevHandle || null);
      return this;
    }
  }, {
    key: "resize",
    value: function resize() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var width = options.width,
          height = options.height;

      if (this.handle === null) {
        (0, _assert.assert)(width === undefined && height === undefined);
        this.width = this.gl.drawingBufferWidth;
        this.height = this.gl.drawingBufferHeight;
        return this;
      }

      if (width === undefined) {
        width = this.gl.drawingBufferWidth;
      }

      if (height === undefined) {
        height = this.gl.drawingBufferHeight;
      }

      if (width !== this.width && height !== this.height) {
        _gltools.log.log(2, "Resizing framebuffer ".concat(this.id, " to ").concat(width, "x").concat(height))();
      }

      for (var attachmentPoint in this.attachments) {
        this.attachments[attachmentPoint].resize({
          width: width,
          height: height
        });
      }

      this.width = width;
      this.height = height;
      return this;
    }
  }, {
    key: "attach",
    value: function attach(attachments) {
      var _this2 = this;

      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref3$clearAttachment = _ref3.clearAttachments,
          clearAttachments = _ref3$clearAttachment === void 0 ? false : _ref3$clearAttachment,
          _ref3$resizeAttachmen = _ref3.resizeAttachments,
          resizeAttachments = _ref3$resizeAttachmen === void 0 ? true : _ref3$resizeAttachmen;

      var newAttachments = {};

      if (clearAttachments) {
        Object.keys(this.attachments).forEach(function (key) {
          newAttachments[key] = null;
        });
      }

      Object.assign(newAttachments, attachments);
      var prevHandle = this.gl.bindFramebuffer(36160, this.handle);

      for (var key in newAttachments) {
        (0, _assert.assert)(key !== undefined, 'Misspelled framebuffer binding point?');
        var attachment = Number(key);
        var descriptor = newAttachments[attachment];
        var object = descriptor;

        if (!object) {
          this._unattach(attachment);
        } else if (object instanceof _renderbuffer.default) {
          this._attachRenderbuffer({
            attachment: attachment,
            renderbuffer: object
          });
        } else if (Array.isArray(descriptor)) {
          var _descriptor = (0, _slicedToArray2.default)(descriptor, 3),
              texture = _descriptor[0],
              _descriptor$ = _descriptor[1],
              layer = _descriptor$ === void 0 ? 0 : _descriptor$,
              _descriptor$2 = _descriptor[2],
              level = _descriptor$2 === void 0 ? 0 : _descriptor$2;

          object = texture;

          this._attachTexture({
            attachment: attachment,
            texture: texture,
            layer: layer,
            level: level
          });
        } else {
          this._attachTexture({
            attachment: attachment,
            texture: object,
            layer: 0,
            level: 0
          });
        }

        if (resizeAttachments && object) {
          object.resize({
            width: this.width,
            height: this.height
          });
        }
      }

      this.gl.bindFramebuffer(36160, prevHandle || null);
      Object.assign(this.attachments, attachments);
      Object.keys(this.attachments).filter(function (key) {
        return !_this2.attachments[key];
      }).forEach(function (key) {
        delete _this2.attachments[key];
      });
    }
  }, {
    key: "checkStatus",
    value: function checkStatus() {
      var gl = this.gl;
      var status = this.getStatus();

      if (status !== 36053) {
        throw new Error(_getFrameBufferStatus(status));
      }

      return this;
    }
  }, {
    key: "getStatus",
    value: function getStatus() {
      var gl = this.gl;
      var prevHandle = gl.bindFramebuffer(36160, this.handle);
      var status = gl.checkFramebufferStatus(36160);
      gl.bindFramebuffer(36160, prevHandle || null);
      return status;
    }
  }, {
    key: "clear",
    value: function clear() {
      var _this3 = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var color = options.color,
          depth = options.depth,
          stencil = options.stencil,
          _options$drawBuffers = options.drawBuffers,
          drawBuffers = _options$drawBuffers === void 0 ? [] : _options$drawBuffers;
      var prevHandle = this.gl.bindFramebuffer(36160, this.handle);

      if (color || depth || stencil) {
        (0, _clear2.clear)(this.gl, {
          color: color,
          depth: depth,
          stencil: stencil
        });
      }

      drawBuffers.forEach(function (value, drawBuffer) {
        (0, _clear2.clearBuffer)(_this3.gl, {
          drawBuffer: drawBuffer,
          value: value
        });
      });
      this.gl.bindFramebuffer(36160, prevHandle || null);
      return this;
    }
  }, {
    key: "readPixels",
    value: function readPixels() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Framebuffer.readPixels() is no logner supported, use readPixelsToArray(framebuffer)')();

      return null;
    }
  }, {
    key: "readPixelsToBuffer",
    value: function readPixelsToBuffer() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Framebuffer.readPixelsToBuffer()is no logner supported, use readPixelsToBuffer(framebuffer)')();

      return null;
    }
  }, {
    key: "copyToDataUrl",
    value: function copyToDataUrl() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Framebuffer.copyToDataUrl() is no logner supported, use copyToDataUrl(framebuffer)')();

      return null;
    }
  }, {
    key: "copyToImage",
    value: function copyToImage() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Framebuffer.copyToImage() is no logner supported, use copyToImage(framebuffer)')();

      return null;
    }
  }, {
    key: "copyToTexture",
    value: function copyToTexture() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Framebuffer.copyToTexture({...}) is no logner supported, use copyToTexture(source, target, opts})')();

      return null;
    }
  }, {
    key: "blit",
    value: function blit() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Framebuffer.blit({...}) is no logner supported, use blit(source, target, opts)')();

      return null;
    }
  }, {
    key: "invalidate",
    value: function invalidate(_ref4) {
      var _ref4$attachments = _ref4.attachments,
          attachments = _ref4$attachments === void 0 ? [] : _ref4$attachments,
          _ref4$x = _ref4.x,
          x = _ref4$x === void 0 ? 0 : _ref4$x,
          _ref4$y = _ref4.y,
          y = _ref4$y === void 0 ? 0 : _ref4$y,
          width = _ref4.width,
          height = _ref4.height;
      var gl2 = (0, _gltools.assertWebGL2Context)(this.gl);
      var prevHandle = gl2.bindFramebuffer(36008, this.handle);
      var invalidateAll = x === 0 && y === 0 && width === undefined && height === undefined;

      if (invalidateAll) {
        gl2.invalidateFramebuffer(36008, attachments);
      } else {
        gl2.invalidateFramebuffer(36008, attachments, x, y, width, height);
      }

      gl2.bindFramebuffer(36008, prevHandle);
      return this;
    }
  }, {
    key: "getAttachmentParameter",
    value: function getAttachmentParameter(attachment, pname, keys) {
      var value = this._getAttachmentParameterFallback(pname);

      if (value === null) {
        this.gl.bindFramebuffer(36160, this.handle);
        value = this.gl.getFramebufferAttachmentParameter(36160, attachment, pname);
        this.gl.bindFramebuffer(36160, null);
      }

      if (keys && value > 1000) {
        value = (0, _constantsToKeys.getKey)(this.gl, value);
      }

      return value;
    }
  }, {
    key: "getAttachmentParameters",
    value: function getAttachmentParameters() {
      var attachment = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 36064;
      var keys = arguments.length > 1 ? arguments[1] : undefined;
      var parameters = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.constructor.ATTACHMENT_PARAMETERS || [];
      var values = {};

      var _iterator2 = _createForOfIteratorHelper(parameters),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var pname = _step2.value;
          var key = keys ? (0, _constantsToKeys.getKey)(this.gl, pname) : pname;
          values[key] = this.getAttachmentParameter(attachment, pname, keys);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return values;
    }
  }, {
    key: "getParameters",
    value: function getParameters() {
      var keys = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var attachments = Object.keys(this.attachments);
      var parameters = {};

      for (var _i = 0, _attachments = attachments; _i < _attachments.length; _i++) {
        var attachmentName = _attachments[_i];
        var attachment = Number(attachmentName);
        var key = keys ? (0, _constantsToKeys.getKey)(this.gl, attachment) : attachment;
        parameters[key] = this.getAttachmentParameters(attachment, keys);
      }

      return parameters;
    }
  }, {
    key: "show",
    value: function show() {
      if (typeof window !== 'undefined') {
        window.open((0, _copyAndBlit.copyToDataUrl)(this), 'luma-debug-texture');
      }

      return this;
    }
  }, {
    key: "log",
    value: function log() {
      var logLevel = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var message = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

      if (logLevel > _gltools.log.level || typeof window === 'undefined') {
        return this;
      }

      message = message || "Framebuffer ".concat(this.id);
      var image = (0, _copyAndBlit.copyToDataUrl)(this, {
        targetMaxHeight: 100
      });

      _gltools.log.image({
        logLevel: logLevel,
        message: message,
        image: image
      }, message)();

      return this;
    }
  }, {
    key: "bind",
    value: function bind() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref5$target = _ref5.target,
          target = _ref5$target === void 0 ? 36160 : _ref5$target;

      this.gl.bindFramebuffer(target, this.handle);
      return this;
    }
  }, {
    key: "unbind",
    value: function unbind() {
      var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref6$target = _ref6.target,
          target = _ref6$target === void 0 ? 36160 : _ref6$target;

      this.gl.bindFramebuffer(target, null);
      return this;
    }
  }, {
    key: "_createDefaultAttachments",
    value: function _createDefaultAttachments(color, depth, stencil, width, height) {
      var defaultAttachments = null;

      if (color) {
        var _parameters;

        defaultAttachments = defaultAttachments || {};
        defaultAttachments[36064] = new _texture2d.default(this.gl, {
          id: "".concat(this.id, "-color0"),
          pixels: null,
          format: 6408,
          type: 5121,
          width: width,
          height: height,
          mipmaps: false,
          parameters: (_parameters = {}, (0, _defineProperty2.default)(_parameters, 10241, 9729), (0, _defineProperty2.default)(_parameters, 10240, 9729), (0, _defineProperty2.default)(_parameters, 10242, 33071), (0, _defineProperty2.default)(_parameters, 10243, 33071), _parameters)
        });
        this.ownResources.push(defaultAttachments[36064]);
      }

      if (depth && stencil) {
        defaultAttachments = defaultAttachments || {};
        defaultAttachments[33306] = new _renderbuffer.default(this.gl, {
          id: "".concat(this.id, "-depth-stencil"),
          format: 35056,
          width: width,
          height: 111
        });
        this.ownResources.push(defaultAttachments[33306]);
      } else if (depth) {
        defaultAttachments = defaultAttachments || {};
        defaultAttachments[36096] = new _renderbuffer.default(this.gl, {
          id: "".concat(this.id, "-depth"),
          format: 33189,
          width: width,
          height: height
        });
        this.ownResources.push(defaultAttachments[36096]);
      } else if (stencil) {
        (0, _assert.assert)(false);
      }

      return defaultAttachments;
    }
  }, {
    key: "_unattach",
    value: function _unattach(attachment) {
      var oldAttachment = this.attachments[attachment];

      if (!oldAttachment) {
        return;
      }

      if (oldAttachment instanceof _renderbuffer.default) {
        this.gl.framebufferRenderbuffer(36160, attachment, 36161, null);
      } else {
        this.gl.framebufferTexture2D(36160, attachment, 3553, null, 0);
      }

      delete this.attachments[attachment];
    }
  }, {
    key: "_attachRenderbuffer",
    value: function _attachRenderbuffer(_ref7) {
      var _ref7$attachment = _ref7.attachment,
          attachment = _ref7$attachment === void 0 ? 36064 : _ref7$attachment,
          renderbuffer = _ref7.renderbuffer;
      var gl = this.gl;
      gl.framebufferRenderbuffer(36160, attachment, 36161, renderbuffer.handle);
      this.attachments[attachment] = renderbuffer;
    }
  }, {
    key: "_attachTexture",
    value: function _attachTexture(_ref8) {
      var _ref8$attachment = _ref8.attachment,
          attachment = _ref8$attachment === void 0 ? 36064 : _ref8$attachment,
          texture = _ref8.texture,
          layer = _ref8.layer,
          level = _ref8.level;
      var gl = this.gl;
      gl.bindTexture(texture.target, texture.handle);

      switch (texture.target) {
        case 35866:
        case 32879:
          var gl2 = (0, _gltools.assertWebGL2Context)(gl);
          gl2.framebufferTextureLayer(36160, attachment, texture.target, level, layer);
          break;

        case 34067:
          var face = mapIndexToCubeMapFace(layer);
          gl.framebufferTexture2D(36160, attachment, face, texture.handle, level);
          break;

        case 3553:
          gl.framebufferTexture2D(36160, attachment, 3553, texture.handle, level);
          break;

        default:
          (0, _assert.assert)(false, 'Illegal texture type');
      }

      gl.bindTexture(texture.target, null);
      this.attachments[attachment] = texture;
    }
  }, {
    key: "_setReadBuffer",
    value: function _setReadBuffer(readBuffer) {
      var gl2 = (0, _gltools.getWebGL2Context)(this.gl);

      if (gl2) {
        gl2.readBuffer(readBuffer);
      } else {
        (0, _assert.assert)(readBuffer === 36064 || readBuffer === 1029, ERR_MULTIPLE_RENDERTARGETS);
      }

      this.readBuffer = readBuffer;
    }
  }, {
    key: "_setDrawBuffers",
    value: function _setDrawBuffers(drawBuffers) {
      var gl = this.gl;
      var gl2 = (0, _gltools.assertWebGL2Context)(gl);

      if (gl2) {
        gl2.drawBuffers(drawBuffers);
      } else {
        var ext = gl.getExtension('WEBGL_draw_buffers');

        if (ext) {
          ext.drawBuffersWEBGL(drawBuffers);
        } else {
          (0, _assert.assert)(drawBuffers.length === 1 && (drawBuffers[0] === 36064 || drawBuffers[0] === 1029), ERR_MULTIPLE_RENDERTARGETS);
        }
      }

      this.drawBuffers = drawBuffers;
    }
  }, {
    key: "_getAttachmentParameterFallback",
    value: function _getAttachmentParameterFallback(pname) {
      var caps = (0, _features.getFeatures)(this.gl);

      switch (pname) {
        case 36052:
          return !caps.WEBGL2 ? 0 : null;

        case 33298:
        case 33299:
        case 33300:
        case 33301:
        case 33302:
        case 33303:
          return !caps.WEBGL2 ? 8 : null;

        case 33297:
          return !caps.WEBGL2 ? 5125 : null;

        case 33296:
          return !caps.WEBGL2 && !caps.EXT_sRGB ? 9729 : null;

        default:
          return null;
      }
    }
  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createFramebuffer();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteFramebuffer(this.handle);
    }
  }, {
    key: "_bindHandle",
    value: function _bindHandle(handle) {
      return this.gl.bindFramebuffer(36160, handle);
    }
  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var colorBufferFloat = options.colorBufferFloat,
          colorBufferHalfFloat = options.colorBufferHalfFloat;
      var supported = true;

      if (colorBufferFloat) {
        supported = Boolean(gl.getExtension('EXT_color_buffer_float') || gl.getExtension('WEBGL_color_buffer_float') || gl.getExtension('OES_texture_float'));
      }

      if (colorBufferHalfFloat) {
        supported = supported && Boolean(gl.getExtension('EXT_color_buffer_float') || gl.getExtension('EXT_color_buffer_half_float'));
      }

      return supported;
    }
  }, {
    key: "getDefaultFramebuffer",
    value: function getDefaultFramebuffer(gl) {
      gl.luma = gl.luma || {};
      gl.luma.defaultFramebuffer = gl.luma.defaultFramebuffer || new Framebuffer(gl, {
        id: 'default-framebuffer',
        handle: null,
        attachments: {}
      });
      return gl.luma.defaultFramebuffer;
    }
  }]);
  return Framebuffer;
}(_resource.default, Symbol.toStringTag);

exports.default = Framebuffer;

function mapIndexToCubeMapFace(layer) {
  return layer < 34069 ? layer + 34069 : layer;
}

function _getFrameBufferStatus(status) {
  var STATUS = Framebuffer.STATUS || {};
  return STATUS[status] || "Framebuffer error ".concat(status);
}

var FRAMEBUFFER_ATTACHMENT_PARAMETERS = [36049, 36048, 33296, 33298, 33299, 33300, 33301, 33302, 33303];
exports.FRAMEBUFFER_ATTACHMENT_PARAMETERS = FRAMEBUFFER_ATTACHMENT_PARAMETERS;
Framebuffer.ATTACHMENT_PARAMETERS = FRAMEBUFFER_ATTACHMENT_PARAMETERS;
//# sourceMappingURL=framebuffer.js.map