"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _resource = _interopRequireDefault(require("./resource"));

var _features = require("../features");

var _gltools = require("@luma.gl/gltools");

var _assert = require("../utils/assert");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var GL_QUERY_RESULT = 0x8866;
var GL_QUERY_RESULT_AVAILABLE = 0x8867;
var GL_TIME_ELAPSED_EXT = 0x88bf;
var GL_GPU_DISJOINT_EXT = 0x8fbb;
var GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8c88;
var GL_ANY_SAMPLES_PASSED = 0x8c2f;
var GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8d6a;

var Query = function (_Resource, _Symbol$toStringTag) {
  (0, _inherits2.default)(Query, _Resource);

  var _super = _createSuper(Query);

  function Query(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Query);
    _this = _super.call(this, gl, opts);
    _this.target = null;
    _this._queryPending = false;
    _this._pollingPromise = null;
    Object.seal((0, _assertThisInitialized2.default)(_this));
    return _this;
  }

  (0, _createClass2.default)(Query, [{
    key: _Symbol$toStringTag,
    get: function get() {
      return 'Query';
    }
  }, {
    key: "beginTimeElapsedQuery",
    value: function beginTimeElapsedQuery() {
      return this.begin(GL_TIME_ELAPSED_EXT);
    }
  }, {
    key: "beginOcclusionQuery",
    value: function beginOcclusionQuery() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$conservative = _ref.conservative,
          conservative = _ref$conservative === void 0 ? false : _ref$conservative;

      return this.begin(conservative ? GL_ANY_SAMPLES_PASSED_CONSERVATIVE : GL_ANY_SAMPLES_PASSED);
    }
  }, {
    key: "beginTransformFeedbackQuery",
    value: function beginTransformFeedbackQuery() {
      return this.begin(GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN);
    }
  }, {
    key: "begin",
    value: function begin(target) {
      if (this._queryPending) {
        return this;
      }

      this.target = target;
      this.gl2.beginQuery(this.target, this.handle);
      return this;
    }
  }, {
    key: "end",
    value: function end() {
      if (this._queryPending) {
        return this;
      }

      if (this.target) {
        this.gl2.endQuery(this.target);
        this.target = null;
        this._queryPending = true;
      }

      return this;
    }
  }, {
    key: "isResultAvailable",
    value: function isResultAvailable() {
      if (!this._queryPending) {
        return false;
      }

      var resultAvailable = this.gl2.getQueryParameter(this.handle, GL_QUERY_RESULT_AVAILABLE);

      if (resultAvailable) {
        this._queryPending = false;
      }

      return resultAvailable;
    }
  }, {
    key: "isTimerDisjoint",
    value: function isTimerDisjoint() {
      return this.gl2.getParameter(GL_GPU_DISJOINT_EXT);
    }
  }, {
    key: "getResult",
    value: function getResult() {
      return this.gl2.getQueryParameter(this.handle, GL_QUERY_RESULT);
    }
  }, {
    key: "getTimerMilliseconds",
    value: function getTimerMilliseconds() {
      return this.getResult() / 1e6;
    }
  }, {
    key: "createPoll",
    value: function createPoll() {
      var _this2 = this;

      var limit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Number.POSITIVE_INFINITY;

      if (this._pollingPromise) {
        return this._pollingPromise;
      }

      var counter = 0;
      this._pollingPromise = new Promise(function (resolve, reject) {
        var poll = function poll() {
          if (_this2.isResultAvailable()) {
            resolve(_this2.getResult());
            _this2._pollingPromise = null;
          } else if (counter++ > limit) {
            reject('Timed out');
            _this2._pollingPromise = null;
          } else {
            requestAnimationFrame(poll);
          }
        };

        requestAnimationFrame(poll);
      });
      return this._pollingPromise;
    }
  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return Query.isSupported(this.gl) ? this.gl2.createQuery() : null;
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl2.deleteQuery(this.handle);
    }
  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var webgl2 = (0, _gltools.isWebGL2)(gl);
      var hasTimerQuery = (0, _features.hasFeatures)(gl, _features.FEATURES.TIMER_QUERY);
      var supported = webgl2 || hasTimerQuery;

      var _iterator = _createForOfIteratorHelper(opts),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var key = _step.value;

          switch (key) {
            case 'queries':
              supported = supported && webgl2;
              break;

            case 'timers':
              supported = supported && hasTimerQuery;
              break;

            default:
              (0, _assert.assert)(false);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return supported;
    }
  }]);
  return Query;
}(_resource.default, Symbol.toStringTag);

exports.default = Query;
//# sourceMappingURL=query.js.map