"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _resource = _interopRequireDefault(require("./resource"));

var _renderbufferFormats = _interopRequireDefault(require("./renderbuffer-formats"));

var _gltools = require("@luma.gl/gltools");

var _assert = require("../utils/assert");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function isFormatSupported(gl, format, formats) {
  var info = formats[format];

  if (!info) {
    return false;
  }

  var value = (0, _gltools.isWebGL2)(gl) ? info.gl2 || info.gl1 : info.gl1;

  if (typeof value === 'string') {
    return gl.getExtension(value);
  }

  return value;
}

var Renderbuffer = function (_Resource, _Symbol$toStringTag) {
  (0, _inherits2.default)(Renderbuffer, _Resource);

  var _super = _createSuper(Renderbuffer);

  function Renderbuffer(gl) {
    var _this;

    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Renderbuffer);
    _this = _super.call(this, gl, opts);

    _this.initialize(opts);

    Object.seal((0, _assertThisInitialized2.default)(_this));
    return _this;
  }

  (0, _createClass2.default)(Renderbuffer, [{
    key: _Symbol$toStringTag,
    get: function get() {
      return 'Renderbuffer';
    }
  }, {
    key: "initialize",
    value: function initialize(_ref) {
      var format = _ref.format,
          _ref$width = _ref.width,
          width = _ref$width === void 0 ? 1 : _ref$width,
          _ref$height = _ref.height,
          height = _ref$height === void 0 ? 1 : _ref$height,
          _ref$samples = _ref.samples,
          samples = _ref$samples === void 0 ? 0 : _ref$samples;
      (0, _assert.assert)(format, 'Needs format');

      this._trackDeallocatedMemory();

      this.gl.bindRenderbuffer(36161, this.handle);

      if (samples !== 0 && (0, _gltools.isWebGL2)(this.gl)) {
        this.gl.renderbufferStorageMultisample(36161, samples, format, width, height);
      } else {
        this.gl.renderbufferStorage(36161, format, width, height);
      }

      this.format = format;
      this.width = width;
      this.height = height;
      this.samples = samples;

      this._trackAllocatedMemory(this.width * this.height * (this.samples || 1) * _renderbufferFormats.default[this.format].bpp);

      return this;
    }
  }, {
    key: "resize",
    value: function resize(_ref2) {
      var width = _ref2.width,
          height = _ref2.height;

      if (width !== this.width || height !== this.height) {
        return this.initialize({
          width: width,
          height: height,
          format: this.format,
          samples: this.samples
        });
      }

      return this;
    }
  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createRenderbuffer();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteRenderbuffer(this.handle);

      this._trackDeallocatedMemory();
    }
  }, {
    key: "_bindHandle",
    value: function _bindHandle(handle) {
      this.gl.bindRenderbuffer(36161, handle);
    }
  }, {
    key: "_syncHandle",
    value: function _syncHandle(handle) {
      this.format = this.getParameter(36164);
      this.width = this.getParameter(36162);
      this.height = this.getParameter(36163);
      this.samples = this.getParameter(36011);
    }
  }, {
    key: "_getParameter",
    value: function _getParameter(pname) {
      this.gl.bindRenderbuffer(36161, this.handle);
      var value = this.gl.getRenderbufferParameter(36161, pname);
      return value;
    }
  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
        format: null
      },
          format = _ref3.format;

      return !format || isFormatSupported(gl, format, _renderbufferFormats.default);
    }
  }, {
    key: "getSamplesForFormat",
    value: function getSamplesForFormat(gl, _ref4) {
      var format = _ref4.format;
      return gl.getInternalformatParameter(36161, format, 32937);
    }
  }]);
  return Renderbuffer;
}(_resource.default, Symbol.toStringTag);

exports.default = Renderbuffer;
//# sourceMappingURL=renderbuffer.js.map