"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _gltools = require("@luma.gl/gltools");

var _init = require("../init");

var _constantsToKeys = require("../webgl-utils/constants-to-keys");

var _assert = require("../utils/assert");

var _utils = require("../utils/utils");

var _stubMethods = require("../utils/stub-methods");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var ERR_RESOURCE_METHOD_UNDEFINED = 'Resource subclass must define virtual methods';

var Resource = function (_Symbol$toStringTag) {
  function Resource(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Resource);
    (0, _gltools.assertWebGLContext)(gl);
    var id = opts.id,
        _opts$userData = opts.userData,
        userData = _opts$userData === void 0 ? {} : _opts$userData;
    this.gl = gl;
    this.gl2 = gl;
    this.id = id || (0, _utils.uid)(this[Symbol.toStringTag]);
    this.userData = userData;
    this._bound = false;
    this._handle = opts.handle;

    if (this._handle === undefined) {
      this._handle = this._createHandle();
    }

    this.byteLength = 0;

    this._addStats();
  }

  (0, _createClass2.default)(Resource, [{
    key: _Symbol$toStringTag,
    get: function get() {
      return 'Resource';
    }
  }, {
    key: "toString",
    value: function toString() {
      return "".concat(this[Symbol.toStringTag] || this.constructor.name, "(").concat(this.id, ")");
    }
  }, {
    key: "handle",
    get: function get() {
      return this._handle;
    }
  }, {
    key: "delete",
    value: function _delete() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$deleteChildren = _ref.deleteChildren,
          deleteChildren = _ref$deleteChildren === void 0 ? false : _ref$deleteChildren;

      var children = this._handle && this._deleteHandle(this._handle);

      if (this._handle) {
        this._removeStats();
      }

      this._handle = null;

      if (children && deleteChildren) {
        children.filter(Boolean).forEach(function (child) {
          return child.delete();
        });
      }

      return this;
    }
  }, {
    key: "bind",
    value: function bind() {
      var funcOrHandle = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.handle;

      if (typeof funcOrHandle !== 'function') {
        this._bindHandle(funcOrHandle);

        return this;
      }

      var value;

      if (!this._bound) {
        this._bindHandle(this.handle);

        this._bound = true;
        value = funcOrHandle();
        this._bound = false;

        this._bindHandle(null);
      } else {
        value = funcOrHandle();
      }

      return value;
    }
  }, {
    key: "unbind",
    value: function unbind() {
      this.bind(null);
    }
  }, {
    key: "getParameter",
    value: function getParameter(pname) {
      var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      pname = (0, _constantsToKeys.getKeyValue)(this.gl, pname);
      (0, _assert.assert)(pname);
      var parameters = this.constructor.PARAMETERS || {};
      var parameter = parameters[pname];

      if (parameter) {
        var isWebgl2 = (0, _gltools.isWebGL2)(this.gl);
        var parameterAvailable = (!('webgl2' in parameter) || isWebgl2) && (!('extension' in parameter) || this.gl.getExtension(parameter.extension));

        if (!parameterAvailable) {
          var webgl1Default = parameter.webgl1;
          var webgl2Default = 'webgl2' in parameter ? parameter.webgl2 : parameter.webgl1;
          var defaultValue = isWebgl2 ? webgl2Default : webgl1Default;
          return defaultValue;
        }
      }

      return this._getParameter(pname, opts);
    }
  }, {
    key: "getParameters",
    value: function getParameters() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var parameters = options.parameters,
          keys = options.keys;
      var PARAMETERS = this.constructor.PARAMETERS || {};
      var isWebgl2 = (0, _gltools.isWebGL2)(this.gl);
      var values = {};
      var parameterKeys = parameters || Object.keys(PARAMETERS);

      var _iterator = _createForOfIteratorHelper(parameterKeys),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var pname = _step.value;
          var parameter = PARAMETERS[pname];
          var parameterAvailable = parameter && (!('webgl2' in parameter) || isWebgl2) && (!('extension' in parameter) || this.gl.getExtension(parameter.extension));

          if (parameterAvailable) {
            var key = keys ? (0, _constantsToKeys.getKey)(this.gl, pname) : pname;
            values[key] = this.getParameter(pname, options);

            if (keys && parameter.type === 'GLenum') {
              values[key] = (0, _constantsToKeys.getKey)(this.gl, values[key]);
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return values;
    }
  }, {
    key: "setParameter",
    value: function setParameter(pname, value) {
      pname = (0, _constantsToKeys.getKeyValue)(this.gl, pname);
      (0, _assert.assert)(pname);
      var parameters = this.constructor.PARAMETERS || {};
      var parameter = parameters[pname];

      if (parameter) {
        var isWebgl2 = (0, _gltools.isWebGL2)(this.gl);
        var parameterAvailable = (!('webgl2' in parameter) || isWebgl2) && (!('extension' in parameter) || this.gl.getExtension(parameter.extension));

        if (!parameterAvailable) {
          throw new Error('Parameter not available on this platform');
        }

        if (parameter.type === 'GLenum') {
          value = (0, _constantsToKeys.getKeyValue)(value);
        }
      }

      this._setParameter(pname, value);

      return this;
    }
  }, {
    key: "setParameters",
    value: function setParameters(parameters) {
      for (var pname in parameters) {
        this.setParameter(pname, parameters[pname]);
      }

      return this;
    }
  }, {
    key: "stubRemovedMethods",
    value: function stubRemovedMethods(className, version, methodNames) {
      return (0, _stubMethods.stubRemovedMethods)(this, className, version, methodNames);
    }
  }, {
    key: "initialize",
    value: function initialize(opts) {}
  }, {
    key: "_createHandle",
    value: function _createHandle() {
      throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
    }
  }, {
    key: "_bindHandle",
    value: function _bindHandle(handle) {
      throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
    }
  }, {
    key: "_getOptsFromHandle",
    value: function _getOptsFromHandle() {
      throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
    }
  }, {
    key: "_getParameter",
    value: function _getParameter(pname, opts) {
      throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
    }
  }, {
    key: "_setParameter",
    value: function _setParameter(pname, value) {
      throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
    }
  }, {
    key: "_context",
    value: function _context() {
      this.gl.luma = this.gl.luma || {};
      return this.gl.luma;
    }
  }, {
    key: "_addStats",
    value: function _addStats() {
      var name = this[Symbol.toStringTag];

      var stats = _init.lumaStats.get('Resource Counts');

      stats.get('Resources Created').incrementCount();
      stats.get("".concat(name, "s Created")).incrementCount();
      stats.get("".concat(name, "s Active")).incrementCount();
    }
  }, {
    key: "_removeStats",
    value: function _removeStats() {
      var name = this[Symbol.toStringTag];

      var stats = _init.lumaStats.get('Resource Counts');

      stats.get("".concat(name, "s Active")).decrementCount();
    }
  }, {
    key: "_trackAllocatedMemory",
    value: function _trackAllocatedMemory(bytes) {
      var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this[Symbol.toStringTag];

      this._trackAllocatedMemoryForContext(bytes, name);

      this._trackAllocatedMemoryForContext(bytes, name, this.gl.canvas && this.gl.canvas.id);

      this.byteLength = bytes;
    }
  }, {
    key: "_trackAllocatedMemoryForContext",
    value: function _trackAllocatedMemoryForContext(bytes) {
      var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this[Symbol.toStringTag];
      var id = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

      var stats = _init.lumaStats.get("Memory Usage".concat(id));

      stats.get('GPU Memory').addCount(bytes);
      stats.get("".concat(name, " Memory")).addCount(bytes);
    }
  }, {
    key: "_trackDeallocatedMemory",
    value: function _trackDeallocatedMemory() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this[Symbol.toStringTag];

      this._trackDeallocatedMemoryForContext(name);

      this._trackDeallocatedMemoryForContext(name, this.gl.canvas && this.gl.canvas.id);

      this.byteLength = 0;
    }
  }, {
    key: "_trackDeallocatedMemoryForContext",
    value: function _trackDeallocatedMemoryForContext() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this[Symbol.toStringTag];
      var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

      var stats = _init.lumaStats.get("Memory Usage".concat(id));

      stats.get('GPU Memory').subtractCount(this.byteLength);
      stats.get("".concat(name, " Memory")).subtractCount(this.byteLength);
    }
  }]);
  return Resource;
}(Symbol.toStringTag);

exports.default = Resource;
//# sourceMappingURL=resource.js.map