"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _gltools = require("@luma.gl/gltools");

var _resource = _interopRequireDefault(require("./resource"));

var _buffer = _interopRequireDefault(require("./buffer"));

var _textureFormats = require("./texture-formats");

var _assert = require("../utils/assert");

var _utils = require("../utils/utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var NPOT_MIN_FILTERS = [9729, 9728];

var WebGLBuffer = globalThis.WebGLBuffer || function WebGLBuffer() {};

var Texture = function (_Resource, _Symbol$toStringTag) {
  (0, _inherits2.default)(Texture, _Resource);

  var _super = _createSuper(Texture);

  function Texture(gl, props) {
    var _this;

    (0, _classCallCheck2.default)(this, Texture);
    var _props$id = props.id,
        id = _props$id === void 0 ? (0, _utils.uid)('texture') : _props$id,
        handle = props.handle,
        target = props.target;
    _this = _super.call(this, gl, {
      id: id,
      handle: handle
    });
    _this.target = target;
    _this.textureUnit = undefined;
    _this.loaded = false;
    _this.width = undefined;
    _this.height = undefined;
    _this.depth = undefined;
    _this.format = undefined;
    _this.type = undefined;
    _this.dataFormat = undefined;
    _this.border = undefined;
    _this.textureUnit = undefined;
    _this.mipmaps = undefined;
    return _this;
  }

  (0, _createClass2.default)(Texture, [{
    key: _Symbol$toStringTag,
    get: function get() {
      return 'Texture';
    }
  }, {
    key: "toString",
    value: function toString() {
      return "Texture(".concat(this.id, ",").concat(this.width, "x").concat(this.height, ")");
    }
  }, {
    key: "initialize",
    value: function initialize() {
      var _this2 = this;

      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var data = props.data;

      if (data instanceof Promise) {
        data.then(function (resolvedImageData) {
          return _this2.initialize(Object.assign({}, props, {
            pixels: resolvedImageData,
            data: resolvedImageData
          }));
        });
        return this;
      }

      var isVideo = typeof HTMLVideoElement !== 'undefined' && data instanceof HTMLVideoElement;

      if (isVideo && data.readyState < HTMLVideoElement.HAVE_METADATA) {
        this._video = null;
        data.addEventListener('loadeddata', function () {
          return _this2.initialize(props);
        });
        return this;
      }

      var _props$pixels = props.pixels,
          pixels = _props$pixels === void 0 ? null : _props$pixels,
          _props$format = props.format,
          format = _props$format === void 0 ? 6408 : _props$format,
          _props$border = props.border,
          border = _props$border === void 0 ? 0 : _props$border,
          _props$recreate = props.recreate,
          recreate = _props$recreate === void 0 ? false : _props$recreate,
          _props$parameters = props.parameters,
          parameters = _props$parameters === void 0 ? {} : _props$parameters,
          _props$pixelStore = props.pixelStore,
          pixelStore = _props$pixelStore === void 0 ? {} : _props$pixelStore,
          _props$textureUnit = props.textureUnit,
          textureUnit = _props$textureUnit === void 0 ? undefined : _props$textureUnit;

      if (!data) {
        data = pixels;
      }

      var width = props.width,
          height = props.height,
          dataFormat = props.dataFormat,
          type = props.type,
          _props$compressed = props.compressed,
          compressed = _props$compressed === void 0 ? false : _props$compressed,
          _props$mipmaps = props.mipmaps,
          mipmaps = _props$mipmaps === void 0 ? true : _props$mipmaps;
      var _props$depth = props.depth,
          depth = _props$depth === void 0 ? 0 : _props$depth;

      var _this$_deduceParamete = this._deduceParameters({
        format: format,
        type: type,
        dataFormat: dataFormat,
        compressed: compressed,
        data: data,
        width: width,
        height: height
      });

      width = _this$_deduceParamete.width;
      height = _this$_deduceParamete.height;
      compressed = _this$_deduceParamete.compressed;
      dataFormat = _this$_deduceParamete.dataFormat;
      type = _this$_deduceParamete.type;
      this.width = width;
      this.height = height;
      this.depth = depth;
      this.format = format;
      this.type = type;
      this.dataFormat = dataFormat;
      this.border = border;
      this.textureUnit = textureUnit;

      if (Number.isFinite(this.textureUnit)) {
        this.gl.activeTexture(33984 + this.textureUnit);
        this.gl.bindTexture(this.target, this.handle);
      }

      if (mipmaps && this._isNPOT()) {
        _gltools.log.warn("texture: ".concat(this, " is Non-Power-Of-Two, disabling mipmaping"))();

        mipmaps = false;

        this._updateForNPOT(parameters);
      }

      this.mipmaps = mipmaps;
      this.setImageData({
        data: data,
        width: width,
        height: height,
        depth: depth,
        format: format,
        type: type,
        dataFormat: dataFormat,
        border: border,
        mipmaps: mipmaps,
        parameters: pixelStore,
        compressed: compressed
      });

      if (mipmaps) {
        this.generateMipmap();
      }

      this.setParameters(parameters);

      if (recreate) {
        this.data = data;
      }

      if (isVideo) {
        this._video = {
          video: data,
          parameters: parameters,
          lastTime: data.readyState >= HTMLVideoElement.HAVE_CURRENT_DATA ? data.currentTime : -1
        };
      }

      return this;
    }
  }, {
    key: "update",
    value: function update() {
      if (this._video) {
        var _this$_video = this._video,
            video = _this$_video.video,
            parameters = _this$_video.parameters,
            lastTime = _this$_video.lastTime;

        if (lastTime === video.currentTime || video.readyState < HTMLVideoElement.HAVE_CURRENT_DATA) {
          return;
        }

        this.setSubImageData({
          data: video,
          parameters: parameters
        });

        if (this.mipmaps) {
          this.generateMipmap();
        }

        this._video.lastTime = video.currentTime;
      }
    }
  }, {
    key: "resize",
    value: function resize(_ref) {
      var height = _ref.height,
          width = _ref.width,
          _ref$mipmaps = _ref.mipmaps,
          mipmaps = _ref$mipmaps === void 0 ? false : _ref$mipmaps;

      if (width !== this.width || height !== this.height) {
        return this.initialize({
          width: width,
          height: height,
          format: this.format,
          type: this.type,
          dataFormat: this.dataFormat,
          border: this.border,
          mipmaps: mipmaps
        });
      }

      return this;
    }
  }, {
    key: "generateMipmap",
    value: function generateMipmap() {
      var _this3 = this;

      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (this._isNPOT()) {
        _gltools.log.warn("texture: ".concat(this, " is Non-Power-Of-Two, disabling mipmaping"))();

        return this;
      }

      this.mipmaps = true;
      this.gl.bindTexture(this.target, this.handle);
      (0, _gltools.withParameters)(this.gl, params, function () {
        _this3.gl.generateMipmap(_this3.target);
      });
      this.gl.bindTexture(this.target, null);
      return this;
    }
  }, {
    key: "setImageData",
    value: function setImageData(options) {
      this._trackDeallocatedMemory('Texture');

      var _options$target = options.target,
          target = _options$target === void 0 ? this.target : _options$target,
          _options$pixels = options.pixels,
          pixels = _options$pixels === void 0 ? null : _options$pixels,
          _options$level = options.level,
          level = _options$level === void 0 ? 0 : _options$level,
          _options$format = options.format,
          format = _options$format === void 0 ? this.format : _options$format,
          _options$border = options.border,
          border = _options$border === void 0 ? this.border : _options$border,
          _options$offset = options.offset,
          offset = _options$offset === void 0 ? 0 : _options$offset,
          _options$parameters = options.parameters,
          parameters = _options$parameters === void 0 ? {} : _options$parameters;
      var _options$data = options.data,
          data = _options$data === void 0 ? null : _options$data,
          _options$type = options.type,
          type = _options$type === void 0 ? this.type : _options$type,
          _options$width = options.width,
          width = _options$width === void 0 ? this.width : _options$width,
          _options$height = options.height,
          height = _options$height === void 0 ? this.height : _options$height,
          _options$dataFormat = options.dataFormat,
          dataFormat = _options$dataFormat === void 0 ? this.dataFormat : _options$dataFormat,
          _options$compressed = options.compressed,
          compressed = _options$compressed === void 0 ? false : _options$compressed;

      if (!data) {
        data = pixels;
      }

      var _this$_deduceParamete2 = this._deduceParameters({
        format: format,
        type: type,
        dataFormat: dataFormat,
        compressed: compressed,
        data: data,
        width: width,
        height: height
      });

      type = _this$_deduceParamete2.type;
      dataFormat = _this$_deduceParamete2.dataFormat;
      compressed = _this$_deduceParamete2.compressed;
      width = _this$_deduceParamete2.width;
      height = _this$_deduceParamete2.height;
      var gl = this.gl;
      gl.bindTexture(this.target, this.handle);
      var dataType = null;

      var _this$_getDataType = this._getDataType({
        data: data,
        compressed: compressed
      });

      data = _this$_getDataType.data;
      dataType = _this$_getDataType.dataType;
      var gl2;
      var compressedTextureSize = 0;
      (0, _gltools.withParameters)(this.gl, parameters, function () {
        switch (dataType) {
          case 'null':
            gl.texImage2D(target, level, format, width, height, border, dataFormat, type, data);
            break;

          case 'typed-array':
            gl.texImage2D(target, level, format, width, height, border, dataFormat, type, data, offset);
            break;

          case 'buffer':
            gl2 = (0, _gltools.assertWebGL2Context)(gl);
            gl2.bindBuffer(35052, data.handle || data);
            gl2.texImage2D(target, level, format, width, height, border, dataFormat, type, offset);
            gl2.bindBuffer(35052, null);
            break;

          case 'browser-object':
            if ((0, _gltools.isWebGL2)(gl)) {
              gl.texImage2D(target, level, format, width, height, border, dataFormat, type, data);
            } else {
              gl.texImage2D(target, level, format, dataFormat, type, data);
            }

            break;

          case 'compressed':
            var _iterator = _createForOfIteratorHelper(data.entries()),
                _step;

            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var _step$value = (0, _slicedToArray2.default)(_step.value, 2),
                    levelIndex = _step$value[0],
                    levelData = _step$value[1];

                gl.compressedTexImage2D(target, levelIndex, levelData.format, levelData.width, levelData.height, border, levelData.data);
                compressedTextureSize += levelData.levelSize;
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }

            break;

          default:
            (0, _assert.assert)(false, 'Unknown image data type');
        }
      });

      if (dataType === 'compressed') {
        this._trackAllocatedMemory(compressedTextureSize, 'Texture');
      } else if (data && data.byteLength) {
        this._trackAllocatedMemory(data.byteLength, 'Texture');
      } else {
        var channels = _textureFormats.DATA_FORMAT_CHANNELS[this.dataFormat] || 4;
        var channelSize = _textureFormats.TYPE_SIZES[this.type] || 1;

        this._trackAllocatedMemory(this.width * this.height * channels * channelSize, 'Texture');
      }

      this.loaded = true;
      return this;
    }
  }, {
    key: "setSubImageData",
    value: function setSubImageData(_ref2) {
      var _this4 = this;

      var _ref2$target = _ref2.target,
          target = _ref2$target === void 0 ? this.target : _ref2$target,
          _ref2$pixels = _ref2.pixels,
          pixels = _ref2$pixels === void 0 ? null : _ref2$pixels,
          _ref2$data = _ref2.data,
          data = _ref2$data === void 0 ? null : _ref2$data,
          _ref2$x = _ref2.x,
          x = _ref2$x === void 0 ? 0 : _ref2$x,
          _ref2$y = _ref2.y,
          y = _ref2$y === void 0 ? 0 : _ref2$y,
          _ref2$width = _ref2.width,
          width = _ref2$width === void 0 ? this.width : _ref2$width,
          _ref2$height = _ref2.height,
          height = _ref2$height === void 0 ? this.height : _ref2$height,
          _ref2$level = _ref2.level,
          level = _ref2$level === void 0 ? 0 : _ref2$level,
          _ref2$format = _ref2.format,
          format = _ref2$format === void 0 ? this.format : _ref2$format,
          _ref2$type = _ref2.type,
          type = _ref2$type === void 0 ? this.type : _ref2$type,
          _ref2$dataFormat = _ref2.dataFormat,
          dataFormat = _ref2$dataFormat === void 0 ? this.dataFormat : _ref2$dataFormat,
          _ref2$compressed = _ref2.compressed,
          compressed = _ref2$compressed === void 0 ? false : _ref2$compressed,
          _ref2$offset = _ref2.offset,
          offset = _ref2$offset === void 0 ? 0 : _ref2$offset,
          _ref2$border = _ref2.border,
          border = _ref2$border === void 0 ? this.border : _ref2$border,
          _ref2$parameters = _ref2.parameters,
          parameters = _ref2$parameters === void 0 ? {} : _ref2$parameters;

      var _this$_deduceParamete3 = this._deduceParameters({
        format: format,
        type: type,
        dataFormat: dataFormat,
        compressed: compressed,
        data: data,
        width: width,
        height: height
      });

      type = _this$_deduceParamete3.type;
      dataFormat = _this$_deduceParamete3.dataFormat;
      compressed = _this$_deduceParamete3.compressed;
      width = _this$_deduceParamete3.width;
      height = _this$_deduceParamete3.height;
      (0, _assert.assert)(this.depth === 0, 'texSubImage not supported for 3D textures');

      if (!data) {
        data = pixels;
      }

      if (data && data.data) {
        var ndarray = data;
        data = ndarray.data;
        width = ndarray.shape[0];
        height = ndarray.shape[1];
      }

      if (data instanceof _buffer.default) {
        data = data.handle;
      }

      this.gl.bindTexture(this.target, this.handle);
      (0, _gltools.withParameters)(this.gl, parameters, function () {
        if (compressed) {
          _this4.gl.compressedTexSubImage2D(target, level, x, y, width, height, format, data);
        } else if (data === null) {
          _this4.gl.texSubImage2D(target, level, x, y, width, height, dataFormat, type, null);
        } else if (ArrayBuffer.isView(data)) {
          _this4.gl.texSubImage2D(target, level, x, y, width, height, dataFormat, type, data, offset);
        } else if (data instanceof WebGLBuffer) {
          var gl2 = (0, _gltools.assertWebGL2Context)(_this4.gl);
          gl2.bindBuffer(35052, data);
          gl2.texSubImage2D(target, level, x, y, width, height, dataFormat, type, offset);
          gl2.bindBuffer(35052, null);
        } else if ((0, _gltools.isWebGL2)(_this4.gl)) {
          var _gl = (0, _gltools.assertWebGL2Context)(_this4.gl);

          _gl.texSubImage2D(target, level, x, y, width, height, dataFormat, type, data);
        } else {
          _this4.gl.texSubImage2D(target, level, x, y, dataFormat, type, data);
        }
      });
      this.gl.bindTexture(this.target, null);
    }
  }, {
    key: "copyFramebuffer",
    value: function copyFramebuffer() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _gltools.log.error('Texture.copyFramebuffer({...}) is no logner supported, use copyToTexture(source, target, opts})')();

      return null;
    }
  }, {
    key: "getActiveUnit",
    value: function getActiveUnit() {
      return this.gl.getParameter(34016) - 33984;
    }
  }, {
    key: "bind",
    value: function bind() {
      var textureUnit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.textureUnit;
      var gl = this.gl;

      if (textureUnit !== undefined) {
        this.textureUnit = textureUnit;
        gl.activeTexture(33984 + textureUnit);
      }

      gl.bindTexture(this.target, this.handle);
      return textureUnit;
    }
  }, {
    key: "unbind",
    value: function unbind() {
      var textureUnit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.textureUnit;
      var gl = this.gl;

      if (textureUnit !== undefined) {
        this.textureUnit = textureUnit;
        gl.activeTexture(33984 + textureUnit);
      }

      gl.bindTexture(this.target, null);
      return textureUnit;
    }
  }, {
    key: "_getDataType",
    value: function _getDataType(_ref3) {
      var data = _ref3.data,
          _ref3$compressed = _ref3.compressed,
          compressed = _ref3$compressed === void 0 ? false : _ref3$compressed;

      if (compressed) {
        return {
          data: data,
          dataType: 'compressed'
        };
      }

      if (data === null) {
        return {
          data: data,
          dataType: 'null'
        };
      }

      if (ArrayBuffer.isView(data)) {
        return {
          data: data,
          dataType: 'typed-array'
        };
      }

      if (data instanceof _buffer.default) {
        return {
          data: data.handle,
          dataType: 'buffer'
        };
      }

      if (data instanceof WebGLBuffer) {
        return {
          data: data,
          dataType: 'buffer'
        };
      }

      return {
        data: data,
        dataType: 'browser-object'
      };
    }
  }, {
    key: "_deduceParameters",
    value: function _deduceParameters(opts) {
      var format = opts.format,
          data = opts.data;
      var width = opts.width,
          height = opts.height,
          dataFormat = opts.dataFormat,
          type = opts.type,
          compressed = opts.compressed;
      var textureFormat = _textureFormats.TEXTURE_FORMATS[format];
      dataFormat = dataFormat || textureFormat && textureFormat.dataFormat;
      type = type || textureFormat && textureFormat.types[0];
      compressed = compressed || textureFormat && textureFormat.compressed;

      var _this$_deduceImageSiz = this._deduceImageSize(data, width, height);

      width = _this$_deduceImageSiz.width;
      height = _this$_deduceImageSiz.height;
      return {
        dataFormat: dataFormat,
        type: type,
        compressed: compressed,
        width: width,
        height: height,
        format: format,
        data: data
      };
    }
  }, {
    key: "_deduceImageSize",
    value: function _deduceImageSize(data, width, height) {
      var size;

      if (typeof ImageData !== 'undefined' && data instanceof ImageData) {
        size = {
          width: data.width,
          height: data.height
        };
      } else if (typeof HTMLImageElement !== 'undefined' && data instanceof HTMLImageElement) {
        size = {
          width: data.naturalWidth,
          height: data.naturalHeight
        };
      } else if (typeof HTMLCanvasElement !== 'undefined' && data instanceof HTMLCanvasElement) {
        size = {
          width: data.width,
          height: data.height
        };
      } else if (typeof ImageBitmap !== 'undefined' && data instanceof ImageBitmap) {
        size = {
          width: data.width,
          height: data.height
        };
      } else if (typeof HTMLVideoElement !== 'undefined' && data instanceof HTMLVideoElement) {
        size = {
          width: data.videoWidth,
          height: data.videoHeight
        };
      } else if (!data) {
        size = {
          width: width >= 0 ? width : 1,
          height: height >= 0 ? height : 1
        };
      } else {
        size = {
          width: width,
          height: height
        };
      }

      (0, _assert.assert)(size, 'Could not deduced texture size');
      (0, _assert.assert)(width === undefined || size.width === width, 'Deduced texture width does not match supplied width');
      (0, _assert.assert)(height === undefined || size.height === height, 'Deduced texture height does not match supplied height');
      return size;
    }
  }, {
    key: "_createHandle",
    value: function _createHandle() {
      return this.gl.createTexture();
    }
  }, {
    key: "_deleteHandle",
    value: function _deleteHandle() {
      this.gl.deleteTexture(this.handle);

      this._trackDeallocatedMemory('Texture');
    }
  }, {
    key: "_getParameter",
    value: function _getParameter(pname) {
      switch (pname) {
        case 4096:
          return this.width;

        case 4097:
          return this.height;

        default:
          this.gl.bindTexture(this.target, this.handle);
          var value = this.gl.getTexParameter(this.target, pname);
          this.gl.bindTexture(this.target, null);
          return value;
      }
    }
  }, {
    key: "_setParameter",
    value: function _setParameter(pname, param) {
      this.gl.bindTexture(this.target, this.handle);
      param = this._getNPOTParam(pname, param);

      switch (pname) {
        case 33082:
        case 33083:
          this.gl.texParameterf(this.handle, pname, param);
          break;

        case 4096:
        case 4097:
          (0, _assert.assert)(false);
          break;

        default:
          this.gl.texParameteri(this.target, pname, param);
          break;
      }

      this.gl.bindTexture(this.target, null);
      return this;
    }
  }, {
    key: "_isNPOT",
    value: function _isNPOT() {
      if ((0, _gltools.isWebGL2)(this.gl)) {
        return false;
      }

      if (!this.width || !this.height) {
        return false;
      }

      return !(0, _utils.isPowerOfTwo)(this.width) || !(0, _utils.isPowerOfTwo)(this.height);
    }
  }, {
    key: "_updateForNPOT",
    value: function _updateForNPOT(parameters) {
      if (parameters[this.gl.TEXTURE_MIN_FILTER] === undefined) {
        parameters[this.gl.TEXTURE_MIN_FILTER] = this.gl.LINEAR;
      }

      if (parameters[this.gl.TEXTURE_WRAP_S] === undefined) {
        parameters[this.gl.TEXTURE_WRAP_S] = this.gl.CLAMP_TO_EDGE;
      }

      if (parameters[this.gl.TEXTURE_WRAP_T] === undefined) {
        parameters[this.gl.TEXTURE_WRAP_T] = this.gl.CLAMP_TO_EDGE;
      }
    }
  }, {
    key: "_getNPOTParam",
    value: function _getNPOTParam(pname, param) {
      if (this._isNPOT()) {
        switch (pname) {
          case 10241:
            if (NPOT_MIN_FILTERS.indexOf(param) === -1) {
              param = 9729;
            }

            break;

          case 10242:
          case 10243:
            if (param !== 33071) {
              param = 33071;
            }

            break;

          default:
            break;
        }
      }

      return param;
    }
  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var format = opts.format,
          linearFiltering = opts.linearFiltering;
      var supported = true;

      if (format) {
        supported = supported && (0, _textureFormats.isFormatSupported)(gl, format);
        supported = supported && (!linearFiltering || (0, _textureFormats.isLinearFilteringSupported)(gl, format));
      }

      return supported;
    }
  }]);
  return Texture;
}(_resource.default, Symbol.toStringTag);

exports.default = Texture;
//# sourceMappingURL=texture.js.map