"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDebugTableForProgramConfiguration = getDebugTableForProgramConfiguration;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _attributeUtils = require("../webgl-utils/attribute-utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function getDebugTableForProgramConfiguration(config) {
  var table = {};
  var header = "Accessors for ".concat(config.id);

  var _iterator = _createForOfIteratorHelper(config.attributeInfos),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var attributeInfo = _step.value;

      if (attributeInfo) {
        var glslDeclaration = getGLSLDeclaration(attributeInfo);
        table["in ".concat(glslDeclaration)] = (0, _defineProperty2.default)({}, header, JSON.stringify(attributeInfo.accessor));
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var _iterator2 = _createForOfIteratorHelper(config.varyingInfos),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var varyingInfo = _step2.value;

      if (varyingInfo) {
        var _glslDeclaration = getGLSLDeclaration(varyingInfo);

        table["out ".concat(_glslDeclaration)] = (0, _defineProperty2.default)({}, header, JSON.stringify(varyingInfo.accessor));
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  return table;
}

function getGLSLDeclaration(attributeInfo) {
  var _attributeInfo$access = attributeInfo.accessor,
      type = _attributeInfo$access.type,
      size = _attributeInfo$access.size;
  var typeAndName = (0, _attributeUtils.getCompositeGLType)(type, size);

  if (typeAndName) {
    return "".concat(typeAndName.name, " ").concat(attributeInfo.name);
  }

  return attributeInfo.name;
}
//# sourceMappingURL=debug-program-configuration.js.map