"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDebugTableForVertexArray = getDebugTableForVertexArray;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _buffer = _interopRequireDefault(require("../classes/buffer"));

var _constantsToKeys = require("../webgl-utils/constants-to-keys");

var _attributeUtils = require("../webgl-utils/attribute-utils");

var _formatValue = require("../utils/format-value");

function getDebugTableForVertexArray(_ref) {
  var vertexArray = _ref.vertexArray,
      _ref$header = _ref.header,
      header = _ref$header === void 0 ? 'Attributes' : _ref$header;

  if (!vertexArray.configuration) {
    return {};
  }

  var table = {};

  if (vertexArray.elements) {
    table.ELEMENT_ARRAY_BUFFER = getDebugTableRow(vertexArray, vertexArray.elements, null, header);
  }

  var attributes = vertexArray.values;

  for (var attributeLocation in attributes) {
    var info = vertexArray._getAttributeInfo(attributeLocation);

    if (info) {
      var rowHeader = "".concat(attributeLocation, ": ").concat(info.name);
      var accessor = vertexArray.accessors[info.location];

      if (accessor) {
        rowHeader = "".concat(attributeLocation, ": ").concat(getGLSLDeclaration(info.name, accessor));
      }

      table[rowHeader] = getDebugTableRow(vertexArray, attributes[attributeLocation], accessor, header);
    }
  }

  return table;
}

function getDebugTableRow(vertexArray, attribute, accessor, header) {
  var _ref4;

  var gl = vertexArray.gl;

  if (!attribute) {
    var _ref2;

    return _ref2 = {}, (0, _defineProperty2.default)(_ref2, header, 'null'), (0, _defineProperty2.default)(_ref2, 'Format ', 'N/A'), _ref2;
  }

  var type = 'NOT PROVIDED';
  var size = 1;
  var verts = 0;
  var bytes = 0;
  var isInteger;
  var marker;
  var value;

  if (accessor) {
    type = accessor.type;
    size = accessor.size;
    type = String(type).replace('Array', '');
    isInteger = type.indexOf('nt') !== -1;
  }

  if (attribute instanceof _buffer.default) {
    var _ref3;

    var buffer = attribute;

    var _buffer$getDebugData = buffer.getDebugData(),
        data = _buffer$getDebugData.data,
        changed = _buffer$getDebugData.changed;

    marker = changed ? '*' : '';
    value = data;
    bytes = buffer.byteLength;
    verts = bytes / data.BYTES_PER_ELEMENT / size;
    var format;

    if (accessor) {
      var instanced = accessor.divisor > 0;
      format = "".concat(instanced ? 'I ' : 'P ', " ").concat(verts, " (x").concat(size, "=").concat(bytes, " bytes ").concat((0, _constantsToKeys.getKey)(gl, type), ")");
    } else {
      isInteger = true;
      format = "".concat(bytes, " bytes");
    }

    return _ref3 = {}, (0, _defineProperty2.default)(_ref3, header, "".concat(marker).concat((0, _formatValue.formatValue)(value, {
      size: size,
      isInteger: isInteger
    }))), (0, _defineProperty2.default)(_ref3, 'Format ', format), _ref3;
  }

  value = attribute;
  size = attribute.length;
  type = String(attribute.constructor.name).replace('Array', '');
  isInteger = type.indexOf('nt') !== -1;
  return _ref4 = {}, (0, _defineProperty2.default)(_ref4, header, "".concat((0, _formatValue.formatValue)(value, {
    size: size,
    isInteger: isInteger
  }), " (constant)")), (0, _defineProperty2.default)(_ref4, 'Format ', "".concat(size, "x").concat(type, " (constant)")), _ref4;
}

function getGLSLDeclaration(name, accessor) {
  var type = accessor.type,
      size = accessor.size;
  var typeAndName = (0, _attributeUtils.getCompositeGLType)(type, size);
  return typeAndName ? "".concat(name, " (").concat(typeAndName.name, ")") : name;
}
//# sourceMappingURL=debug-vertex-array.js.map