"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isObjectEmpty = isObjectEmpty;
exports.isPowerOfTwo = isPowerOfTwo;
exports.uid = uid;

var _assert = require("./assert");

var uidCounters = {};

function uid() {
  var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';
  uidCounters[id] = uidCounters[id] || 1;
  var count = uidCounters[id]++;
  return "".concat(id, "-").concat(count);
}

function isPowerOfTwo(n) {
  (0, _assert.assert)(typeof n === 'number', 'Input must be a number');
  return n && (n & n - 1) === 0;
}

function isObjectEmpty(obj) {
  var isEmpty = true;

  for (var key in obj) {
    isEmpty = false;
    break;
  }

  return isEmpty;
}
//# sourceMappingURL=utils.js.map