import { isWebGL2, assertWebGL2Context, withParameters } from '@luma.gl/gltools';
import Texture from './texture';
import { DATA_FORMAT_CHANNELS, TYPE_SIZES } from './texture-formats';
import Buffer from './buffer';
export default class Texture3D extends Texture {
  get [Symbol.toStringTag]() {
    return 'Texture3D';
  }

  static isSupported(gl) {
    return isWebGL2(gl);
  }

  constructor(gl) {
    let props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    assertWebGL2Context(gl);
    props = Object.assign({
      depth: 1
    }, props, {
      target: 32879,
      unpackFlipY: false
    });
    super(gl, props);
    this.initialize(props);
    Object.seal(this);
  }

  setImageData(_ref) {
    let {
      level = 0,
      dataFormat = 6408,
      width,
      height,
      depth = 1,
      border = 0,
      format,
      type = 5121,
      offset = 0,
      data,
      parameters = {}
    } = _ref;

    this._trackDeallocatedMemory('Texture');

    this.gl.bindTexture(this.target, this.handle);
    withParameters(this.gl, parameters, () => {
      if (ArrayBuffer.isView(data)) {
        this.gl.texImage3D(this.target, level, dataFormat, width, height, depth, border, format, type, data);
      }

      if (data instanceof Buffer) {
        this.gl.bindBuffer(35052, data.handle);
        this.gl.texImage3D(this.target, level, dataFormat, width, height, depth, border, format, type, offset);
      }
    });

    if (data && data.byteLength) {
      this._trackAllocatedMemory(data.byteLength, 'Texture');
    } else {
      const channels = DATA_FORMAT_CHANNELS[this.dataFormat] || 4;
      const channelSize = TYPE_SIZES[this.type] || 1;

      this._trackAllocatedMemory(this.width * this.height * this.depth * channels * channelSize, 'Texture');
    }

    this.loaded = true;
    return this;
  }

}
//# sourceMappingURL=texture-3d.js.map