import Buffer from '../classes/buffer';
import { getKey } from '../webgl-utils/constants-to-keys';
import { getCompositeGLType } from '../webgl-utils/attribute-utils';
import { formatValue } from '../utils/format-value';
export function getDebugTableForVertexArray(_ref) {
  let {
    vertexArray,
    header = 'Attributes'
  } = _ref;

  if (!vertexArray.configuration) {
    return {};
  }

  const table = {};

  if (vertexArray.elements) {
    table.ELEMENT_ARRAY_BUFFER = getDebugTableRow(vertexArray, vertexArray.elements, null, header);
  }

  const attributes = vertexArray.values;

  for (const attributeLocation in attributes) {
    const info = vertexArray._getAttributeInfo(attributeLocation);

    if (info) {
      let rowHeader = "".concat(attributeLocation, ": ").concat(info.name);
      const accessor = vertexArray.accessors[info.location];

      if (accessor) {
        rowHeader = "".concat(attributeLocation, ": ").concat(getGLSLDeclaration(info.name, accessor));
      }

      table[rowHeader] = getDebugTableRow(vertexArray, attributes[attributeLocation], accessor, header);
    }
  }

  return table;
}

function getDebugTableRow(vertexArray, attribute, accessor, header) {
  const {
    gl
  } = vertexArray;

  if (!attribute) {
    return {
      [header]: 'null',
      'Format ': 'N/A'
    };
  }

  let type = 'NOT PROVIDED';
  let size = 1;
  let verts = 0;
  let bytes = 0;
  let isInteger;
  let marker;
  let value;

  if (accessor) {
    type = accessor.type;
    size = accessor.size;
    type = String(type).replace('Array', '');
    isInteger = type.indexOf('nt') !== -1;
  }

  if (attribute instanceof Buffer) {
    const buffer = attribute;
    const {
      data,
      changed
    } = buffer.getDebugData();
    marker = changed ? '*' : '';
    value = data;
    bytes = buffer.byteLength;
    verts = bytes / data.BYTES_PER_ELEMENT / size;
    let format;

    if (accessor) {
      const instanced = accessor.divisor > 0;
      format = "".concat(instanced ? 'I ' : 'P ', " ").concat(verts, " (x").concat(size, "=").concat(bytes, " bytes ").concat(getKey(gl, type), ")");
    } else {
      isInteger = true;
      format = "".concat(bytes, " bytes");
    }

    return {
      [header]: "".concat(marker).concat(formatValue(value, {
        size,
        isInteger
      })),
      'Format ': format
    };
  }

  value = attribute;
  size = attribute.length;
  type = String(attribute.constructor.name).replace('Array', '');
  isInteger = type.indexOf('nt') !== -1;
  return {
    [header]: "".concat(formatValue(value, {
      size,
      isInteger
    }), " (constant)"),
    'Format ': "".concat(size, "x").concat(type, " (constant)")
  };
}

function getGLSLDeclaration(name, accessor) {
  const {
    type,
    size
  } = accessor;
  const typeAndName = getCompositeGLType(type, size);
  return typeAndName ? "".concat(name, " (").concat(typeAndName.name, ")") : name;
}
//# sourceMappingURL=debug-vertex-array.js.map