import { log } from '@luma.gl/gltools';
import { Stats } from '@probe.gl/stats';
import { isBrowser } from '@probe.gl/env';
const VERSION = typeof "8.5.21" !== 'undefined' ? "8.5.21" : 'untranspiled source';
const STARTUP_MESSAGE = 'set luma.log.level=1 (or higher) to trace rendering';
export class StatsManager {
  constructor() {
    this.stats = new Map();
  }

  get(name) {
    if (!this.stats.has(name)) {
      this.stats.set(name, new Stats({
        id: name
      }));
    }

    return this.stats.get(name);
  }

}
const lumaStats = new StatsManager();

if (globalThis.luma && globalThis.luma.VERSION !== VERSION) {
  throw new Error("luma.gl - multiple VERSIONs detected: ".concat(globalThis.luma.VERSION, " vs ").concat(VERSION));
}

if (!globalThis.luma) {
  if (isBrowser()) {
    log.log(1, "luma.gl ".concat(VERSION, " - ").concat(STARTUP_MESSAGE))();
  }

  globalThis.luma = globalThis.luma || {
    VERSION,
    version: VERSION,
    log,
    stats: lumaStats,
    globals: {
      modules: {},
      nodeIO: {}
    }
  };
}

export { lumaStats };
export default globalThis.luma;
//# sourceMappingURL=init.js.map