// luma.gl
// SPDX-License-Identifier: MIT
// Copyright (c) vis.gl contributors
import { GL } from '@luma.gl/constants';
/** Get shader attribute type from GL constants */
export function getShaderAttributeTypeFromGL(type, components) {
    const dataType = getShaderDataTypeFromGL(type);
    switch (components) {
        case 1:
            return dataType;
        case 2:
            return `vec2<${dataType}>`;
        case 3:
            return `vec2<${dataType}>`;
        case 4:
            return `vec2<${dataType}>`;
        default:
            throw new Error(String(components));
    }
}
/** Get shader data type from GL constants */
export function getShaderDataTypeFromGL(type) {
    switch (type) {
        case 5124:
            return 'i32';
        case 5125:
            return 'u32';
        case 5122:
            return 'i32';
        case 5123:
            return 'u32';
        case 5120:
            return 'i32';
        case 5121:
            return 'u32';
        case 5126:
            return 'f32';
        case 5131:
            return 'f16';
        default:
            throw new Error(String(type));
    }
}
/** GetGL constant from shader data type */
export function getGLFromShaderDataType(type) {
    switch (type) {
        // TODO
        case 'i32':
            return 5124;
        case 'u32':
            return 5125;
        case 'f32':
            return 5126;
        case 'f16':
            return 5131;
        default:
            throw new Error(String(type));
    }
}
//# sourceMappingURL=shader-formats.js.map