import { ShaderUniformType, ShaderAttributeType, VertexFormat } from '@luma.gl/core';
import { GL, GLUniformType, GLCompositeType, GLDataType } from '@luma.gl/constants';
/** Check is uniform is of sampler type */
export declare function isSamplerUniform(type: GLUniformType): boolean;
/** Decomposes a composite type (GL.VEC3) into a basic type (GL.FLOAT) and components (3) */
export declare function decodeGLUniformType(glUniformType: GL): {
    format: ShaderUniformType;
    components: number;
    glType: GLDataType;
};
/** Decomposes a composite type (GL.VEC3) into a basic type (GL.FLOAT) and components (3) */
export declare function decodeGLAttributeType(glAttributeType: GL): {
    attributeType: ShaderAttributeType;
    vertexFormat: VertexFormat;
    components: number;
};
/** Decomposes a composite type GL.VEC3 into a basic type (GL.FLOAT) and components (3) */
export declare function decomposeCompositeGLDataType(compositeGLDataType: GLCompositeType): {
    type: GLDataType;
    components: number;
} | null;
export declare function getCompositeGLDataType(type: GL, components: any): {
    glType: GLDataType;
    name: string;
} | null;
//# sourceMappingURL=decode-webgl-types.d.ts.map