// luma.gl
// SPDX-License-Identifier: MIT
// Copyright (c) vis.gl contributors
import { GL } from '@luma.gl/constants';
/** Check is uniform is of sampler type */
export function isSamplerUniform(type) {
    return SAMPLER_TYPES.includes(type);
}
const SAMPLER_TYPES = [
    35678,
    35680,
    35679,
    35682,
    36289,
    36292,
    36293,
    36298,
    36299,
    36300,
    36303,
    36306,
    36307,
    36308,
    36311
];
// Composite types table
const COMPOSITE_GL_TYPES = {
    [5126]: [5126, 1, 'float', 'f32', 'float32'],
    [35664]: [5126, 2, 'vec2', 'vec2<f32>', 'float32x2'],
    [35665]: [5126, 3, 'vec3', 'vec3<f32>', 'float32x3'],
    [35666]: [5126, 4, 'vec4', 'vec4<f32>', 'float32x4'],
    [5124]: [5124, 1, 'int', 'i32', 'sint32'],
    [35667]: [5124, 2, 'ivec2', 'vec2<i32>', 'sint32x2'],
    [35668]: [5124, 3, 'ivec3', 'vec3<i32>', 'sint32x3'],
    [35669]: [5124, 4, 'ivec4', 'vec4<i32>', 'sint32x4'],
    [5125]: [5125, 1, 'uint', 'u32', 'uint32'],
    [36294]: [5125, 2, 'uvec2', 'vec2<u32>', 'uint32x2'],
    [36295]: [5125, 3, 'uvec3', 'vec3<u32>', 'uint32x3'],
    [36296]: [5125, 4, 'uvec4', 'vec4<u32>', 'uint32x4'],
    [35670]: [5126, 1, 'bool', 'f32', 'float32'],
    [35671]: [5126, 2, 'bvec2', 'vec2<f32>', 'float32x2'],
    [35672]: [5126, 3, 'bvec3', 'vec3<f32>', 'float32x3'],
    [35673]: [5126, 4, 'bvec4', 'vec4<f32>', 'float32x4'],
    // TODO - are sizes/components below correct?
    [35674]: [5126, 8, 'mat2', 'mat2x2<f32>'], // 4
    [35685]: [5126, 8, 'mat2x3', 'mat2x3<f32>'], // 6
    [35686]: [5126, 8, 'mat2x4', 'mat2x4<f32>'], // 8
    [35687]: [5126, 12, 'mat3x2', 'mat3x2<f32>'], // 6
    [35675]: [5126, 12, 'mat3', 'mat3x3<f32>'], // 9
    [35688]: [5126, 12, 'mat3x4', 'mat3x4<f32>'], // 12
    [35689]: [5126, 16, 'mat4x2', 'mat4x2<f32>'], // 8
    [35690]: [5126, 16, 'mat4x3', 'mat4x3<f32>'], // 12
    [35676]: [5126, 16, 'mat4', 'mat4x4<f32>'] // 16
};
/** Decomposes a composite type (GL.VEC3) into a basic type (GL.FLOAT) and components (3) */
export function decodeGLUniformType(glUniformType) {
    const typeAndSize = COMPOSITE_GL_TYPES[glUniformType];
    if (!typeAndSize) {
        throw new Error('uniform');
    }
    const [glType, components, , format] = typeAndSize;
    return { format, components, glType };
}
/** Decomposes a composite type (GL.VEC3) into a basic type (GL.FLOAT) and components (3) */
export function decodeGLAttributeType(glAttributeType) {
    const typeAndSize = COMPOSITE_GL_TYPES[glAttributeType];
    if (!typeAndSize) {
        throw new Error('attribute');
    }
    const [, components, , shaderType, vertexFormat] = typeAndSize;
    // TODO sanity - if (shaderType.startsWith('mat' ...))
    const attributeType = shaderType;
    return { attributeType, vertexFormat, components }; // , glType};
}
/** Decomposes a composite type GL.VEC3 into a basic type (GL.FLOAT) and components (3) */
export function decomposeCompositeGLDataType(compositeGLDataType) {
    const typeAndSize = COMPOSITE_GL_TYPES[compositeGLDataType];
    if (!typeAndSize) {
        return null;
    }
    const [type, components] = typeAndSize;
    return { type, components };
}
export function getCompositeGLDataType(type, components) {
    switch (type) {
        case 5120:
        case 5121:
        case 5122:
        case 5123:
            type = 5126;
            break;
        default:
    }
    for (const glType in COMPOSITE_GL_TYPES) {
        const [compType, compComponents, name] = COMPOSITE_GL_TYPES[glType];
        if (compType === type && compComponents === components) {
            return { glType: Number(glType), name };
        }
    }
    return null;
}
//# sourceMappingURL=decode-webgl-types.js.map