import { TypedArray, TypedArrayConstructor } from '@math.gl/types';
import { GLDataType, GLPixelType } from '@luma.gl/constants';
/**
 * Converts TYPED ARRAYS to corresponding GL constant
 * Used to auto deduce gl parameter types
 * @deprecated Use getDataTypeFromTypedArray
 * @param arrayOrType
 * @returns
 */
export declare function getGLTypeFromTypedArray(arrayOrType: TypedArray): GLDataType;
/**
 * Converts GL constant to corresponding TYPED ARRAY
 * Used to auto deduce gl parameter types
 * @deprecated Use getTypedArrayFromDataType
 * @param glType
 * @param param1
 * @returns
 */
export declare function getTypedArrayFromGLType(glType: GLDataType | GLPixelType, options?: {
    clamped?: boolean;
}): TypedArrayConstructor;
/**
 * Flip rows (can be used on arrays returned from `Framebuffer.readPixels`)
 * https: *stackoverflow.com/questions/41969562/
 * how-can-i-flip-the-result-of-webglrenderingcontext-readpixels
 * @param param0
 */
export declare function flipRows(options: {
    data: TypedArray;
    width: number;
    height: number;
    bytesPerPixel?: number;
    temp?: Uint8Array;
}): void;
export declare function scalePixels(options: {
    data: TypedArray;
    width: number;
    height: number;
}): {
    data: Uint8Array;
    width: number;
    height: number;
};
//# sourceMappingURL=typed-array-utils.d.ts.map