import type { BufferProps } from '@luma.gl/core';
import { Buffer } from '@luma.gl/core';
import { GL } from '@luma.gl/constants';
import { WebGLDevice } from "../webgl-device.js";
/** WebGL Buffer interface */
export declare class WEBGLBuffer extends Buffer {
    readonly device: WebGLDevice;
    readonly gl: WebGL2RenderingContext;
    readonly handle: WebGLBuffer;
    /** Target in OpenGL defines the type of buffer */
    readonly glTarget: GL.ARRAY_BUFFER | GL.ELEMENT_ARRAY_BUFFER | GL.UNIFORM_BUFFER;
    /** Usage is a hint on how frequently the buffer will be updates */
    readonly glUsage: GL.STATIC_DRAW | GL.DYNAMIC_DRAW;
    /** Index type is needed when issuing draw calls, so we pre-compute it */
    readonly glIndexType: GL.UNSIGNED_SHORT | GL.UNSIGNED_INT;
    /** Number of bytes allocated on the GPU for this buffer */
    byteLength: number;
    /** Number of bytes used */
    bytesUsed: number;
    constructor(device: WebGLDevice, props?: BufferProps);
    /** Allocate a new buffer and initialize to contents of typed array */
    _initWithData(data: ArrayBuffer | ArrayBufferView, byteOffset?: number, byteLength?: number): void;
    _initWithByteLength(byteLength: number): this;
    destroy(): void;
    write(data: ArrayBufferView, byteOffset?: number): void;
    /** Asynchronously read data from the buffer */
    readAsync(byteOffset?: number, byteLength?: number): Promise<Uint8Array>;
    /** Synchronously read data from the buffer. WebGL only. */
    readSyncWebGL(byteOffset?: number, byteLength?: number): Uint8Array;
}
//# sourceMappingURL=webgl-buffer.d.ts.map