import { CommandEncoder, CommandEncoderProps } from '@luma.gl/core';
import type { CopyBufferToBufferOptions, CopyBufferToTextureOptions, CopyTextureToBufferOptions, CopyTextureToTextureOptions, QuerySet, Buffer } from '@luma.gl/core';
import { WEBGLCommandBuffer } from "./webgl-command-buffer.js";
import { WebGLDevice } from "../webgl-device.js";
export declare class WEBGLCommandEncoder extends CommandEncoder {
    readonly device: WebGLDevice;
    readonly commandBuffer: WEBGLCommandBuffer;
    constructor(device: WebGLDevice, props: CommandEncoderProps);
    destroy(): void;
    finish(): void;
    copyBufferToBuffer(options: CopyBufferToBufferOptions): void;
    copyBufferToTexture(options: CopyBufferToTextureOptions): void;
    copyTextureToBuffer(options: CopyTextureToBufferOptions): void;
    copyTextureToTexture(options: CopyTextureToTextureOptions): void;
    pushDebugGroup(groupLabel: string): void;
    popDebugGroup(): void;
    insertDebugMarker(markerLabel: string): void;
    resolveQuerySet(querySet: QuerySet, destination: Buffer, options?: {
        firstQuery?: number;
        queryCount?: number;
        destinationOffset?: number;
    }): void;
}
//# sourceMappingURL=webgl-command-encoder.d.ts.map