import type { Device, TextureProps, TextureViewProps, Sampler, SamplerProps, TextureCubeFace, ExternalImage, Texture1DData, Texture2DData, Texture3DData, TextureCubeData, TextureArrayData, TextureCubeArrayData } from '@luma.gl/core';
import { Texture } from '@luma.gl/core';
import { GL, GLPixelType, GLSamplerParameters, GLTexelDataFormat, GLTextureTarget } from '@luma.gl/constants';
import { WebGLDevice } from "../webgl-device.js";
import { WEBGLSampler } from "./webgl-sampler.js";
import { WEBGLTextureView } from "./webgl-texture-view.js";
/**
 * WebGL... the texture API from hell... hopefully made simpler
 */
export declare class WEBGLTexture extends Texture {
    readonly device: WebGLDevice;
    readonly gl: WebGL2RenderingContext;
    handle: WebGLTexture;
    sampler: WEBGLSampler;
    view: WEBGLTextureView;
    mipmaps: boolean;
    /** Whether the internal format is compressed */
    compressed: boolean;
    /**
     * The WebGL target corresponding to the texture type
     * @note `target` cannot be modified by bind:
     * textures are special because when you first bind them to a target,
     * When you first bind a texture as a GL_TEXTURE_2D, you are saying that this texture is a 2D texture.
     * And it will always be a 2D texture; this state cannot be changed ever.
     * A texture that was first bound as a GL_TEXTURE_2D, must always be bound as a GL_TEXTURE_2D;
     * attempting to bind it as GL_TEXTURE_3D will give rise to a run-time error
     */
    glTarget: GLTextureTarget;
    /** The WebGL format - essentially channel structure */
    glFormat: GLTexelDataFormat;
    /** The WebGL data format - the type of each channel */
    glType: GLPixelType;
    /** The WebGL constant corresponding to the WebGPU style constant in format */
    glInternalFormat: GL;
    /** Texture binding slot - TODO - move to texture view? */
    textureUnit: number;
    constructor(device: Device, props: TextureProps);
    /** Initialize texture with supplied props */
    _initialize(propsWithData: TextureProps): void;
    destroy(): void;
    createView(props: TextureViewProps): WEBGLTextureView;
    setSampler(sampler?: Sampler | SamplerProps): void;
    generateMipmap(options?: {
        force?: boolean;
    }): void;
    copyExternalImage(options: {
        image: ExternalImage;
        sourceX?: number;
        sourceY?: number;
        width?: number;
        height?: number;
        depth?: number;
        mipLevel?: number;
        x?: number;
        y?: number;
        z?: number;
        aspect?: 'all' | 'stencil-only' | 'depth-only';
        colorSpace?: 'srgb';
        premultipliedAlpha?: boolean;
        flipY?: boolean;
    }): {
        width: number;
        height: number;
    };
    setTexture1DData(data: Texture1DData): void;
    /** Set a simple texture */
    setTexture2DData(lodData: Texture2DData, depth?: number): void;
    /**
     * Sets a 3D texture
     * @param data
     */
    setTexture3DData(data: Texture3DData): void;
    /**
     * Set a Texture Cube Data
     * @todo - could support TextureCubeArray with depth
     * @param data
     * @param index
     */
    setTextureCubeData(data: TextureCubeData, depth?: number): void;
    /**
     * Sets an entire texture array
     * @param data
     */
    setTextureArrayData(data: TextureArrayData): void;
    /**
     * Sets an entire texture cube array
     * @param data
     */
    setTextureCubeArrayData(data: TextureCubeArrayData): void;
    setTextureCubeFaceData(lodData: Texture2DData, face: TextureCubeFace, depth?: number): void;
    /** Update external texture (video frame or canvas) @deprecated Use ExternalTexture */
    update(): void;
    /** @todo update this method to accept LODs */
    setImageDataForFace(options: any): void;
    _getImageDataMap(faceData: Record<string | GL, any>): Record<GL, any>;
    /**
     * Sets sampler parameters on texture
     */
    _setSamplerParameters(parameters: GLSamplerParameters): void;
    /**
     * Copy a region of data from a CPU memory buffer into this texture.
     * @todo -   GLUnpackParameters parameters
     */
    protected _setMipLevel(depth: number, mipLevel: number, textureData: Texture2DData, glTarget?: GL): void;
    getActiveUnit(): number;
    bind(textureUnit?: number): number;
    unbind(textureUnit?: number): number | undefined;
}
//# sourceMappingURL=webgl-texture.d.ts.map