import type { CanvasContextProps, TextureFormat } from '@luma.gl/core';
import { CanvasContext } from '@luma.gl/core';
import { WebGLDevice } from "./webgl-device.js";
import { WEBGLFramebuffer } from "./resources/webgl-framebuffer.js";
/**
 * A WebGL Canvas Context which manages the canvas and handles drawing buffer resizing etc
 */
export declare class WebGLCanvasContext extends CanvasContext {
    readonly device: WebGLDevice;
    readonly format: TextureFormat;
    readonly depthStencilFormat: TextureFormat;
    presentationSize: [number, number];
    private _framebuffer;
    get [Symbol.toStringTag](): string;
    constructor(device: WebGLDevice, props: CanvasContextProps);
    getCurrentFramebuffer(): WEBGLFramebuffer;
    /** Resizes and updates render targets if necessary */
    update(): void;
    /**
     * Resize the canvas' drawing buffer.
     *
     * Can match the canvas CSS size, and optionally also consider devicePixelRatio
     * Can be called every frame
     *
     * Regardless of size, the drawing buffer will always be scaled to the viewport, but
     * for best visual results, usually set to either:
     *  canvas CSS width x canvas CSS height
     *  canvas CSS width * devicePixelRatio x canvas CSS height * devicePixelRatio
     * See http://webgl2fundamentals.org/webgl/lessons/webgl-resizing-the-canvas.html
     */
    resize(options?: {
        width?: number;
        height?: number;
        useDevicePixels?: boolean | number;
    }): void;
    commit(): void;
}
//# sourceMappingURL=webgl-canvas-context.d.ts.map