import { Buffer } from '@luma.gl/core';
import { GL } from '@luma.gl/constants';
/**
 * Attribute descriptor object
 * @deprecated Use ShaderLayout
 */
export interface AccessorObject {
    buffer?: Buffer;
    offset?: number;
    stride?: number;
    /** @deprecated - Use accessor.stepMode */
    divisor?: number;
    /** @deprecated - Infer from format */
    type?: number;
    /** @deprecated - Infer from format */
    size?: number;
    /** @deprecated - Infer from format */
    normalized?: boolean;
    /** @deprecated - Infer from format */
    integer?: boolean;
    /** @deprecated */
    index?: number;
}
declare const DEFAULT_ACCESSOR_VALUES: {
    offset: number;
    stride: number;
    type: GL;
    size: number;
    divisor: number;
    normalized: boolean;
    integer: boolean;
};
export declare class Accessor implements AccessorObject {
    offset?: number;
    stride?: number;
    type?: number;
    size?: number;
    divisor?: number;
    normalized?: boolean;
    integer?: boolean;
    buffer?: Buffer;
    index?: number;
    static getBytesPerElement(accessor: Accessor | AccessorObject): number;
    static getBytesPerVertex(accessor: AccessorObject): number;
    static resolve(...accessors: AccessorObject[]): Accessor;
    constructor(...accessors: AccessorObject[]);
    toString(): string;
    get BYTES_PER_ELEMENT(): number;
    get BYTES_PER_VERTEX(): number;
    _assign(props?: AccessorObject): this;
}
export { DEFAULT_ACCESSOR_VALUES };
//# sourceMappingURL=accessor.d.ts.map