import { parseZoneInfo, hasIntl } from "../impl/util";
import Zone from "../zone";

let singleton = null;

export default class LocalZone extends Zone {
  static get instance() {
    if (singleton === null) {
      singleton = new LocalZone();
    }
    return singleton;
  }

  get type() {
    return "local";
  }

  get name() {
    if (hasIntl()) {
      return new Intl.DateTimeFormat().resolvedOptions().timeZone;
    } else return "local";
  }

  get universal() {
    return false;
  }

  offsetName(ts, { format, locale }) {
    return parseZoneInfo(ts, format, locale);
  }

  offset(ts) {
    return -new Date(ts).getTimezoneOffset();
  }

  equals(otherZone) {
    return otherZone.type === "local";
  }

  get isValid() {
    return true;
  }
}
