/**
 * @file m3u8/index.js
 *
 * Utilities for parsing M3U8 files. If the entire manifest is available,
 * `Parser` will create an object representation with enough detail for managing
 * playback. `ParseStream` and `LineStream` are lower-level parsing primitives
 * that do not assume the entirety of the manifest is ready and expose a
 * ReadableStream-like interface.
 */

import LineStream from './line-stream';
import ParseStream from './parse-stream';
import Parser from './parser';

module.exports = {
  LineStream,
  ParseStream,
  Parser
};
