export interface SketchRNNInfo {
    max_seq_len: number;
    mode: number;
    name: string;
    scale_factor: number;
    version: number;
}
export interface StrokePDF {
    pi: Float32Array;
    muX: Float32Array;
    muY: Float32Array;
    sigmaX: Float32Array;
    sigmaY: Float32Array;
    corr: Float32Array;
    pen: Float32Array;
}
export interface LSTMState {
    c: Float32Array;
    h: Float32Array;
}
export declare class SketchRNN {
    private checkpointURL;
    private forgetBias;
    private initialized;
    info: SketchRNNInfo;
    numUnits: number;
    pixelFactor: number;
    scaleFactor: number;
    private weights;
    private weightDims;
    private outputKernel;
    private outputBias;
    private lstmKernel;
    private lstmBias;
    private rawVars;
    private NMIXTURE;
    constructor(checkpointURL: string);
    isInitialized(): boolean;
    private instantiateFromJSON;
    initialize(): Promise<void>;
    dispose(): void;
    setPixelFactor(scale: number): void;
    update(stroke: number[], state: LSTMState): LSTMState;
    updateStrokes(strokes: number[][], state: LSTMState, steps?: number): LSTMState;
    getPDF(state: LSTMState, temperature?: number, softmaxTemperature?: number): StrokePDF;
    zeroState(): LSTMState;
    copyState(rnnState: LSTMState): LSTMState;
    zeroInput(): number[];
    sample(pdf: StrokePDF): number[];
    simplifyLine(line: number[][], tolerance?: number): number[][];
    simplifyLines(lines: number[][][], tolerance?: number): number[][][];
    linesToStroke(lines: number[][][]): number[][];
    lineToStroke(line: number[][], lastPoint: number[]): number[][];
}
