# make-iterator [![NPM version](https://badge.fury.io/js/make-iterator.svg)](http://badge.fury.io/js/make-iterator)  [![Build Status](https://travis-ci.org/jonschlinkert/make-iterator.svg)](https://travis-ci.org/jonschlinkert/make-iterator)

> Convert an argument into a valid iterator. Based on the `.makeIterator()` implementation in mout https://github.com/mout/mout.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i make-iterator --save
```

## Usage

```js
var iterator = require('make-iterator');

function someFn(arr, cb, thisArg) {
  cb = iterator(cb, thisArg);
  var len = arr.length, i = -1;
  var res;
  while (++i < len) {
    res = cb(arr[i], i, arr);
    if (res === false) {
      // do somethine
    } else {
      // do something else
    }
  }
  return res;
}
```

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## Related projects

* [any](https://github.com/jonschlinkert/any): Returns `true` if a value exists in the given string, array or object.
* [arr-filter](https://github.com/jonschlinkert/arr-filter): Faster alternative to javascript's native filter method.
* [arr-map](https://github.com/jonschlinkert/arr-map): Faster, node.js focused alternative to JavaScript's native array map.
* [array-every](https://github.com/jonschlinkert/array-every): Returns true if the callback returns truthy for all elements in the given array.
* [collection-map](https://github.com/jonschlinkert/collection-map): Returns an array of mapped values from an array or object.
* [utils](https://github.com/jonschlinkert/utils): Fast, generic JavaScript/node.js utility functions.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/make-iterator/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Copyright (c) 2012, 2013 moutjs team and contributors (http://moutjs.com)
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on July 17, 2015._