/* malevic@0.18.3 - May 12, 2020 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('malevic/dom')) :
    typeof define === 'function' && define.amd ? define(['exports', 'malevic/dom'], factory) :
    (global = global || self, factory((global.Malevic = global.Malevic || {}, global.Malevic.State = {}), global.Malevic.DOM));
}(this, (function (exports, dom) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }

    var currentUseStateFn = null;
    function useState(initialState) {
        if (!currentUseStateFn) {
            throw new Error('`useState()` should be called inside a component');
        }
        return currentUseStateFn(initialState);
    }
    function withState(type) {
        var Stateful = function (props) {
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var context = dom.getContext();
            var useState = function (initial) {
                if (!context) {
                    return { state: initial, setState: null };
                }
                var store = context.store, refresh = context.refresh;
                store.state = store.state || initial;
                var setState = function (newState) {
                    if (lock) {
                        throw new Error('Setting state during unboxing causes infinite loop');
                    }
                    store.state = __assign(__assign({}, store.state), newState);
                    refresh();
                };
                return {
                    state: store.state,
                    setState: setState,
                };
            };
            var lock = true;
            var prevUseStateFn = currentUseStateFn;
            currentUseStateFn = useState;
            var result;
            try {
                result = type.apply(void 0, __spreadArrays([props], children));
            }
            finally {
                currentUseStateFn = prevUseStateFn;
                lock = false;
            }
            return result;
        };
        return Stateful;
    }

    exports.useState = useState;
    exports.withState = withState;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
